<?php

/*
 *  Pour un site en espranto, on peut tre tent de proposer les pages en
 *  utf-8, mais aussi en notation 'cx' (le caractre 'x' n'existant pas en
 *  espranto, les esprantistes l'accollent aux lettres g, h, c, u etc.
 *  pour former les 6 caractres composs de la langue) ou en entits html.
 *  Je fais a avec un ob_Start('kodo'), o la fonction kodo() fait la
 *  transformation de toute la page vue, si besoin est, en fonction du
 *  cookie 'kodo'.
 *  
 *  Rsultat en cours de programmation sur http://eo.MondeDiplo.com/
 *  
 *  Ce script doit tre appel au dbut de chaque squelette ; penser aussi 
 *  rgler le charset du squelette sur utf-8. ET dans spip (en ajoutant
 *  ('charset','utf-8') dans la table spip_meta)
 */

/// pose le cookie si necessaire
if ($var_kodo) {
	if ($var_kodo == 'cx')
		$kodo = 'cx';
	else if ($var_kodo == 'entites')
		$kodo = 'entites';
	else
		$kodo = 'utf-8';

	if ($kodo<>'utf-8') // valeur defaut
		setcookie('kodo', $kodo, time()+3600*24*365, '/');
}

/// demarre le buffer si ncessaire
if ($kodo<>'utf-8') {
	ob_start('kodo');
}

/// traite le buffer
function kodo($source) {
	if ($GLOBALS['kodo'] == 'cx')
		return esperanto_cx($source);
	else if ($GLOBALS['kodo'] == 'entites')
		return utf8ToUnicodeEntities ($source);
	else
		return $source;
}

/// pour afficher un bloc de choix de code
function kodo_bloc() {
	echo "<div style='border: 1px dashed #cccccc; font-size: 10px;'>\n";
	echo "<b>KODO:</b><br>\n";
	$kododo=$GLOBALS['kodo'];
	if (!$kododo) $kododo='utf-8';
	$lien = $GLOBALS['clean_link'];
	$codes = array('cx', 'utf-8', 'entites');
	while (list(,$code) = each ($codes)) {
		$lien->addVar('var_kodo', $code);
		$link = $lien->getUrl();
		echo ($kododo==$code) ? "<b>$code</b>" : "<a href='$link'>$code</a>";
		echo "<br>\n";
	}
	echo "</div>\n";
}


/**
* takes a string of utf-8 encoded characters and converts it to a string of unicode entities
* each unicode entitiy has the form &#nnnnn; n={0..9} and can be displayed by utf-8 supporting
* browsers
* @param $source string encoded using utf-8 [STRING]
* @return string of unicode entities [STRING]
* @access public
*/
function utf8ToUnicodeEntities ($source) {
// array used to figure what number to decrement from character order value
// according to number of characters used to map unicode to ascii by utf-8
$decrement[4] = 240;
$decrement[3] = 224;
$decrement[2] = 192;
$decrement[1] = 0;

// the number of bits to shift each charNum by
$shift[1][0] = 0;
$shift[2][0] = 6;
$shift[2][1] = 0;
$shift[3][0] = 12;
$shift[3][1] = 6;
$shift[3][2] = 0;
$shift[4][0] = 18;
$shift[4][1] = 12;
$shift[4][2] = 6;
$shift[4][3] = 0;

$pos = 0;
$len = strlen ($source);
$encodedString = '';
while ($pos < $len) {
$asciiPos = ord (substr ($source, $pos, 1));
if (($asciiPos >= 240) && ($asciiPos <= 255)) {
// 4 chars representing one unicode character
$thisLetter = substr ($source, $pos, 4);
$pos += 4;
}
else if (($asciiPos >= 224) && ($asciiPos <= 239)) {
// 3 chars representing one unicode character
$thisLetter = substr ($source, $pos, 3);
$pos += 3;
}
else if (($asciiPos >= 192) && ($asciiPos <= 223)) {
// 2 chars representing one unicode character
$thisLetter = substr ($source, $pos, 2);
$pos += 2;
}
else {
// 1 char (lower ascii)
$thisLetter = substr ($source, $pos, 1);
$pos += 1;
}

// process the string representing the letter to a unicode entity
$thisLen = strlen ($thisLetter);
$thisPos = 0;
$decimalCode = 0;
while ($thisPos < $thisLen) {
$thisCharOrd = ord (substr ($thisLetter, $thisPos, 1));
if ($thisPos == 0) {
$charNum = intval ($thisCharOrd - $decrement[$thisLen]);
$decimalCode += ($charNum << $shift[$thisLen][$thisPos]);
}
else {
$charNum = intval ($thisCharOrd - 128);
$decimalCode += ($charNum << $shift[$thisLen][$thisPos]);
}

$thisPos++;
}

if ($thisLen == 1)
$encodedLetter = $thisLetter;
//$encodedLetter = "&#". str_pad($decimalCode, 3, "0", STR_PAD_LEFT) . ';';
else
$encodedLetter = "&#". str_pad($decimalCode, 5, "0", STR_PAD_LEFT) . ';';

$encodedString .= $encodedLetter;
}

return $encodedString;
}

function esperanto_cx($source) {
	$esperanto = array (
'&#00264;' => 'Cx',
'&#00265;' => 'cx',
'&#00284;' => 'Gx',
'&#00285;' => 'gx',
'&#00292;' => 'Hx',
'&#00293;' => 'hx',
'&#00308;' => 'Jx',
'&#00309;' => 'jx',
'&#00348;' => 'Sx',
'&#00349;' => 'sx',
'&#00364;' => 'Ux',
'&#00365;' => 'ux'
	);
	$encoded = utf8ToUnicodeEntities ($source);
	$encoded = strtr ($encoded, $esperanto);
	return $encoded;
}


?>
