<?php

	include_once ("special_diplo.php3");

function mes_cahiers($label='') {
	$cahiers = Array(
		574 => "proche-orient",
		390 => "europe",
		465 => "ameriquelatine",
		770 => "irak",
		55 => "kosovo"
	);

	if ($label) {
		while (list($id, $cahier) = each ($cahiers))
			if ($cahier == $label)
				return $id;
	} else
		return $cahiers;
}

function generer_url_article($id_article) {
	if (! $id_article) $id_article = 0;
	$result = spip_query("SELECT id_rubrique,id_secteur,descriptif,ps FROM spip_articles WHERE id_article=$id_article");
	$row = spip_fetch_array($result);
	$id_secteur = $row['id_secteur'];
	$id_rubrique = $row['id_rubrique'];
	$ps = trim($row['ps']);
	$descriptif = trim($row['descriptif']);

	$url = "/spip/article.php3?id_article=$id_article"; // par defaut

	// d'abord les cahiers
	$cahiers = mes_cahiers();
	if ($cahier = $cahiers[$id_secteur]) {
		if (ereg("^$cahier/", $descriptif))
			$url = "/cahier/$descriptif";
		else
			$url = "/cahier/$cahier/a$id_article";
	}
	else
	switch ($id_secteur) {
		case 1:			// revues
			$url = "/revues/$descriptif";
			break;

		case 29:		// cartes
			$url = "/cartes/$descriptif";
			break;

		case 53: 		// divers
			$url = "/$descriptif";
			break;

		case 1379:		// mav
			$url = "/$descriptif";
			break;

		case 54:		// divers doc (chronos, etc.)
			$url = "/cahier/$descriptif";
			break;

		case 919:		// archives
			$url = "/$descriptif";
			break;

		case 901:		// dossiers
			if (ereg("^=(http://.+)",$descriptif,$regs)){
				$url = $regs[1];
			} else
		        $url = "/dossiers/$descriptif";
			break;

		case 1341:		// une et livres
			if ($id_rubrique == 1341 AND ereg("^une\/",$ps))
				$url = "/spip/appel_une.php3";	// une de test
			else
		    	$url = "/$descriptif";		// livre
			break;

		case 1387:		// portfolio
			$url = "/portfolio/$descriptif";
			break;
	}
	return $url;
}

function generer_url_rubrique($id_rubrique) {
	if (!$id_rubrique) $id_rubrique = 0;
	$result = spip_query("SELECT * FROM spip_rubriques WHERE id_rubrique=$id_rubrique");
	$row = spip_fetch_array($result);
	$id_secteur = $row['id_secteur'];
	$titre = $row['titre'];
	$descriptif = trim($row['descriptif']);

	$url = "/spip/rubrique.php3?id_rubrique=$id_rubrique";  // defaut

	// d'abord les cahiers
	$cahiers = mes_cahiers();
	if ($cahier = $cahiers[$id_secteur]) {
		if (ereg("^$cahier/", $descriptif))
			$url = "/cahier/$descriptif";
		else
			$url = "/cahier/$cahier/r$id_rubrique";
	}
	else if ($id_secteur ==1){
		$url = "/revues/";

	} elseif ($id_secteur == 29){
		$url = "/cartes/";

	} elseif ($id_secteur == 901){
        $url = "/dossiers/";

	} elseif ($id_secteur == 919){	// archives
		// cf extraire_date dans mes_fonctions.php3
		if (ereg("([1-2][0-9]{3})[^0-9]*(0?[1-9]|1[0-2])",$titre,$regs))
			$url = "/$regs[1]/$regs[2]/";
		else
			$url = '/';
    }

	return $url;
}

function generer_url_breve($id_breve) {
	$id_breve = (int) $id_breve;
	$result = spip_query("SELECT * FROM spip_breves where id_breve=$id_breve");	
	$row = spip_fetch_array($result);
	$id_rubrique = $row['id_rubrique'];

	if ($id_rubrique == 1341) {
		$url = "/".$row['lien_titre'];
	} else
		$url = "/spip/breve.php3?id_breve=$id_breve";

	return $url;
}

function generer_url_forum($id_forum) {
	$url = "/spip/forum.php3?id_forum=$id_forum";
	return $url;
}

function generer_url_mot($id_mot) {
	$result = spip_query("SELECT * FROM spip_mots WHERE id_mot=$id_mot");
	$row = spip_fetch_array($result);
	$type = $row['type'];
	$descriptif = $row['descriptif'];
	if ($type == 'sujet') {
		$url = "/index/sujet/$descriptif";
	} else if ($type == 'pays') {
		$url = "/index/pays/$descriptif";
	} else if ($id_mot == 567)
		$url = "/spip/appel_une.php3";
	else
		$url = "/spip/mot.php3?id_mot=$id_mot";
	return $url;
}

function generer_url_auteur($id_auteur) {
	$url = "auteur.php3?id_auteur=$id_auteur";
	return $url;
}

function generer_url_document($id_document) {
	if ($id_document > 0) {
		$query = "SELECT fichier FROM spip_documents WHERE id_document = $id_document";
		$result = spip_query($query);
		if ($row = spip_fetch_array($result)) {
			$url = $row['fichier'];
		}
	}
	return $url;
}


function recuperer_parametres_url($fond, $url) {
	global $contexte, $chemin_cache;

		// secteur 919 = Archives
		if (eregi("^/([12][0-9][0-9][0-9]/[01][0-9])/$", $url, $match)){
			$not_found = true;
			$uri = $match[1];
			$result = spip_query("SELECT * FROM spip_rubriques WHERE id_secteur = 919 AND titre like '$uri"."%'");
			if ($row = spip_fetch_array($result)){
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$not_found = false;
			}
		} else if (
		eregi("^/([12][0-9][0-9][0-9]/[01][0-9]/[a-z\_]+/[0-9a-z\.]*)$", $url, $match)
		OR eregi("^/(mav/[[:alnum:]]+/[a-z\_]+/[0-9a-z\.]*)$", $url, $match) ) {
			$not_found = true;
			$uri = ereg_replace("\.html$","",$match[1]);

			// cherche URI exact
			$result = spip_query("SELECT id_article,descriptif FROM spip_articles WHERE id_secteur = 919 AND descriptif = '$uri' AND FIND_IN_SET(statut,'publie,prop') LIMIT 0,1");
			$row = spip_fetch_array($result);

			// ou approximatif (plus lent? donc en second rang...)
			if (! $row) {
				$result = spip_query("SELECT id_article,descriptif FROM spip_articles WHERE id_secteur = 919 AND descriptif LIKE '$uri"."%' AND FIND_IN_SET(statut,'publie,prop') LIMIT 0,1");
				$row = spip_fetch_array($result);
			}

			// on en tient un
			if ($row){
				$contexte['id_article'] = $row['id_article'];
				ereg("^([^ ]+)",$row['descriptif'],$match);
				$the_url = trim($match[1]);
				if ($the_url != $uri){
					@unlink($chemin_cache);
					@header("Location: http://www.monde-diplomatique.fr/$the_url");
					exit();
				}
				$not_found = false;
			}
		}

	else if (ereg('^/revues/([0-9]{2,4})(-|/)([0-9]{1,2})($|/|\?)', $url, $match)) {
		$contexte['annee_redac'] = $match[1];
		$contexte['mois_redac'] = $match[3];
		$date = true;
	}

	else if (ereg('^/index/(pays|sujet)/([a-z]*)', $url, $match)) {
		$not_found = true;
		$mot = $match[2];
		if ($mot) {
			$query = "select id_mot from spip_mots where descriptif='$mot'";
			if ($row = spip_fetch_array(spip_query($query))){
				$contexte['id_mot'] = $row['id_mot'];
				$not_found = false;
			}
		} else {
			$contexte['type'] = $match[1];
			$not_found = false;
		}	

	}

	else if (ereg('^/(revues|dossiers|cartes|pays|sujet|cahier|glossaire|portfolio|diplotv|livre|mav)', $url, $match)) {
		$not_found = true;
		$publi = $match[1];

		/* CAHIER : id_secteur = "Cahiers" */
		if ($publi == 'cahier') {
			// recuperer le nom du cahier et le code de la page demandee
			if (eregi("/cahier/([a-z\-]+)/([a-z0-9\.\-]*)",$url,$match)) {
				$cahier = $match[1];
				$doc = $match[2];

				if ($doc == 'plan') {	// recuperer le plan
					$doc = '';
				}

				// les articles et les rubriques sans precision de descriptif
				if (ereg("^([ar])([0-9]+)", $doc, $regs) AND ($id_cahier = mes_cahiers($cahier))) {
					if ($regs[1] == 'a') {
						$id_article = $regs[2];
						$query = "SELECT id_article FROM spip_articles WHERE id_article=$id_article AND id_secteur = $id_cahier AND FIND_IN_SET(statut,'publie,prop')";
						if ($row = spip_fetch_array(spip_query($query))){
							$contexte['id_article'] = $row['id_article'];
							$not_found = false;
						}
					}
					else if ($regs[1] == 'r') {
						$id_rubrique = $regs[2];
						$query = "SELECT id_rubrique FROM spip_rubriques WHERE id_rubrique=$id_rubrique AND id_secteur = $id_cahier";
						if ($row = spip_fetch_array(spip_query($query))){
							$contexte['id_rubrique'] = $row['id_rubrique'];
							$not_found = false;
						}
					}
				}
				else	// se baser sur un descriptif complet
				{
					$query = "SELECT id_rubrique FROM spip_rubriques WHERE descriptif='$cahier/$doc'";
					if ($row = spip_fetch_array(spip_query($query))){
						$contexte['id_rubrique'] = $row['id_rubrique'];
						$not_found = false;
					} else {
						$query = "SELECT id_article FROM spip_articles WHERE descriptif='$cahier/$doc' AND FIND_IN_SET(statut,'publie,prop')";
						if ($row = spip_fetch_array(spip_query($query))){
							$contexte['id_article'] = $row['id_article'];
							$not_found = false;
						}
					}
				}
			}
		}

		/* GlOSSAIRE  */
		else if ($publi == 'glossaire') {
			// recuperer le nom du cahier et le code de la page demandee
			if (eregi("^/(glossaire/[a-z\-]+)/([a-z0-9\.\-]*)",$url,$match)) {
				$cahier = $match[1];
				$doc = $match[2];
				$query = "SELECT id_breve FROM spip_breves WHERE id_rubrique = 1341 and lien_titre = '$cahier/$doc'";
				if ($row = spip_fetch_array(spip_query($query))) {
					$contexte['id_breve'] = $row['id_breve'];
					$not_found = false;
				}
			}
		}

		/* Maniere de voir */
		else if ($publi == 'mav') {
			if (eregi("^/(mav/[[:alnum:]]+)", $url, $match)) {
				$cahier = $match[1];
				$query = "SELECT id_article FROM spip_articles WHERE id_secteur = 1379 AND descriptif like '$cahier%' AND FIND_IN_SET(statut,'publie,prop')";
				if ($row = spip_fetch_array(spip_query($query))) {
					$contexte['id_article'] = $row['id_article'];
					$not_found = false;
				}
			}
		}

		/* DiploTV */
		else if ($publi == 'diplotv') {
			$query = "SELECT id_breve FROM spip_breves WHERE id_rubrique = 1341 and lien_titre = 'diplotv/'";
			if ($row = spip_fetch_array(spip_query($query))) {
				$contexte['id_breve'] = $row['id_breve'];
				$not_found = false;
			}
		}

		/* Portfolio */
		else if ($publi == 'portfolio') {
			if (eregi("^/portfolio/([a-z\-]+)",$url,$match)) {
				$portf = $match[1];
				$query = "SELECT id_article FROM spip_articles WHERE id_secteur = 1387 and descriptif like '$portf%' AND FIND_IN_SET(statut,'publie,prop')";
				if ($row = spip_fetch_array(spip_query($query))) {
					$contexte['id_article'] = $row['id_article'];
					$not_found = false;
				}
			}
		}

		/* REVUES : id_secteur=1 */
		else if ($publi == 'revues') {
			if (ereg('^/revues/([[:alnum:]._]+)($|\?)', $url, $match)) {
				$descriptif = $match[1];
				$query = "SELECT id_article FROM spip_articles WHERE id_secteur=1 AND descriptif='$descriptif' AND FIND_IN_SET(statut,'publie,prop')";
				$result = spip_query($query);
				if ($row = spip_fetch_array($result)) {
					$contexte['id_article'] = $row['id_article'];
					$not_found = false;
				}
			} else { // liste de revues
				$not_found = false;
			}
		}

		/* CARTES : id_secteur=29 */
		else if ($publi == 'cartes') {
			if (ereg('cartes/([-a-zA-Z0-9._\-]+)($|\?)', $url, $match)) {
				$descriptif = $match[1];
				$query = "SELECT id_article FROM spip_articles WHERE id_secteur=29 AND descriptif='$descriptif' AND FIND_IN_SET(statut,'publie,prop')";
				$result = spip_query($query);
				if ($row = spip_fetch_array($result)) {
					$contexte['id_article'] = $row['id_article'];
					$not_found = false;
				}
			} else {
				$contexte['id_rubrique'] = 29;
				$not_found = false;
			}
		}

		/* LIVRES : id_secteur=1341 */
		else if ($publi == 'livre') {
			if (eregi('(livre/[a-z\-]+/[a-z0-9\.\-]*)', $url, $match)) {
				$descriptif = $match[1];
				$query = "SELECT id_article FROM spip_articles WHERE id_secteur=1341 AND descriptif='$descriptif' AND FIND_IN_SET(statut,'publie,prop')";
				$result = spip_query($query);
				if ($row = spip_fetch_array($result)) {
					$contexte['id_article'] = $row['id_article'];
					$not_found = false;
				}
			}
		}

		/* DOSSIERS : id_secteur=901 */
		else if ($publi == 'dossiers') {
			if (ereg('dossiers/([-a-zA-Z0-9._\-]+/)?($|\?)', $url, $match)) {
				if ($descriptif = $match[1]) {
					$query = "SELECT id_article,chapo FROM spip_articles WHERE id_secteur=901 AND descriptif='$descriptif' AND FIND_IN_SET(statut,'publie,prop')";
					$result = spip_query($query);
					if ($row = spip_fetch_array($result)) {
						$contexte['id_article'] = $row['id_article'];
						$not_found = false;
						if (ereg("^=(http://[^[:space:]]+)", $row['chapo'], $match)) {
							$the_url = $match[1];
							@unlink($chemin_cache);
                    		@header("Location: $the_url");
							exit();
						}
					}
				} else {
					$contexte['id_rubrique'] = 901;
					$not_found = false;
				}
			}
		}

		/* MOTS-CLES */
		else if (($publi == 'pays')||($publi == 'sujet')) {
			if (ereg('(pays|sujet)/([-a-zA-Z0-9._\-]+)($|\?)', $url, $match)) {
				$descriptif = $match[2];
				$query = "SELECT id_mot FROM spip_mots WHERE descriptif='$descriptif'";
				$result = spip_query($query);
				if ($row = spip_fetch_array($result)) {
					$contexte['id_mot'] = $row['id_mot'];
					$not_found = false;
				} else {
					$contexte['id_mot'] = 0;  	// mot vide pour creation de cache
					$not_found = false;			// plus rapide pour la page ghana
				}								// que $not_found = true;
			}
		}
	} // fin publi

	/* 404 */
	if ($not_found) {
		@unlink ($chemin_cache);
		@header("HTTP/1.0 404 Not Found");
		$REDIRECT_URL = $url;
		$descriptif='';
		include "/www/monde-diplomatique/error/404.php3";
		exit();
	}
}

?>
