<?

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_TEXTE")) return;
define("_ECRIRE_INC_TEXTE", "1");


//
// Variables globales : a virer pour une gestion intelligente de la langue
if (!$lang || $HTTP_GET_VARS['lang'] || $HTTP_POST_VARS['lang'] || $HTTP_COOKIE_VARS['lang'])
	$lang = 'fr';
if ($ouvre_note == '') {
	$ouvre_ref  = '&nbsp;[';
	$ferme_ref  = ']';
	$ouvre_note = '[';
	$ferme_note = '] ';
}


//
// Trouver une locale qui 'marche' (utile ??)
$lang2 = strtoupper($lang);
setlocale('LC_CTYPE', "$lang") ||
setlocale('LC_CTYPE', "$lang2_$lang") ||
setlocale('LC_CTYPE', "$lang_$lang2");


//
// Si besoin cree le code qui remplacera la puce, l'intertitre, etc.
if (!$puce) {
	if (file_exists("puce.gif")) {
		$puce_taille = getimagesize("puce.gif");
		$puce = "<img src='puce.gif' align='top' alt='- ' ".$puce_taille[3]." border='0'> ";
	} else {
		$puce = "- ";
	}
}

if (!$debut_intertitre) {
	$debut_intertitre = "\n&nbsp;<h3 class=\"spip\">\n";
	$fin_intertitre = "\n</h3><br>\n";
}



// Securite : empecher l'execution de code PHP
function interdire_scripts($source) {
	$source = eregi_replace("<(\%|\?|( *)script)", "&lt;\\1", $source);
	return $source;
}

function PtoBR($texte){
	$texte=eregi_replace("</p>", "\n", $texte);
	$texte=eregi_replace("<p([[:space:]][^>]*)?".">", "<br>", $texte);
	return $texte;
}

function vider_date($letexte) {
	if (ereg("^0000-00-00", $letexte)) return '';
	return $letexte;
}

// transformer "1er" en "01"
function chiffrespar2($in)
{
	return substr('00'.ereg_replace('[^0-9]', '', $in), -2);
}

function recup_heure($numdate){
	if (!$numdate) return '';

	if (ereg('([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})', $numdate, $regs)) {
		$heures = $regs[1];
		$minutes = $regs[2];
		$secondes = $regs[3];
	}
	return array($heures, $minutes, $secondes);
}

function heures($numdate) {
	$date_array = recup_heure($numdate);
	if ($date_array)
		list($heures,$minutes,$secondes) = $date_array;
	else
		return '';
	return $heures;
}

function minutes($numdate) {
	$date_array = recup_heure($numdate);
	if ($date_array)
		list($heures,$minutes,$secondes) = $date_array;
	else
		return '';
	return $minutes;
}

function secondes($secondes) {
	$date_array = recup_heure($numdate);
	if ($date_array)
		list($heures,$minutes,$secondes) = $date_array;
	else
		return '';
	return $secondes;
}

function recup_date($numdate){
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	elseif (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	elseif (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	if (substr($jour, 0, 1) == '0') $jour = substr($jour, 1);

	return array($annee, $mois, $jour);
}

function affdate_base($numdate, $vue) {
	global $lang;
	$date_array = recup_date($numdate);
	if ($date_array)
		list($annee, $mois, $jour) = $date_array;
	else
		return '';

	$saison = "hiver";
	if (($mois == 3 AND $jour >= 21) OR $mois > 3) $saison = "printemps";
	if (($mois == 6 AND $jour >= 21) OR $mois > 6) $saison = "t";
	if (($mois == 9 AND $jour >= 21) OR $mois > 9) $saison = "automne";
	if (($mois == 12 AND $jour >= 21) OR $mois > 12) $saison = "hiver";

	if ($lang == "fr") {
		if ($jour == '1') $jour = '1er';
		$tab_mois = array(0,
			'janvier', 'fvrier', 'mars', 'avril', 'mai', 'juin',
			'juillet', 'aot', 'septembre', 'octobre', 'novembre', 'dcembre');
		$avjc = ' av. J.C.';
	}
	elseif ($lang == "en"){
		switch($jour) {
		case '1':
			$jour = '1st';
			break;
		case '2':
			$jour = '2nd';
			break;
		case '3':
			$jour = '3rd';
			break;
		case '21':
			$jour = '21st';
			break;
		case '22':
			$jour = '22nd';
			break;
		case '23':
			$jour = '23rd';
			break;
		case '31':
			$jour = '31st';
			break;
		}
		$tab_mois = array(0,
			'January', 'February', 'March', 'April', 'May', 'June',
			'July', 'August', 'September', 'October', 'November', 'December');
		$avjc = ' B.C.';
	}

	if ($jour) $jour .= ' ';
	$mois = $tab_mois[(int) $mois];
	if ($annee < 0) {
		$annee = -$annee.$avjc;
		$avjc = true;
	}
	else $avjc = false;

	switch ($vue) {
	case 'saison':
		return $saison;

	case 'court':
		if ($avjc) return $annee;
		$a = date('Y');
		if ($annee < ($a - 100) OR $annee > ($a + 100)) return $annee;
		if ($annee != $a) return ucfirst($mois)." $annee";
		return $jour.$mois;

	case 'entier':
		if ($avjc) return $annee;
		return "$jour$mois $annee";

	case 'mois':
		//if ($avjc) return $annee;
		return "$mois";

	case 'mois_annee':
		if ($avjc) return $annee;
		return "$mois $annee";
	}

	return '<blink>format non d&eacute;fini</blink>';
}



function nom_jour($numdate){
	global $lang;
	$date_array = recup_date($numdate);
	if ($date_array)
		list($annee,$mois,$jour) = $date_array;
	else
		return '';
	
	$nom = mktime(1,1,1,$mois,$jour,$annee);
	$nom = date("D",$nom);

	if ($lang == "fr") {
		switch($nom) {
			case 'Sun': $nom='dimanche'; break;
			case 'Mon': $nom='lundi'; break;
			case 'Tue': $nom='mardi'; break;
			case 'Wed': $nom='mercredi'; break;
			case 'Thu': $nom='jeudi'; break;
			case 'Fri': $nom='vendredi'; break;
			case 'Sat': $nom='samedi'; break;
		}
	}
	elseif ($lang == "en") {
		switch($nom) {
			case 'Sun': $nom='Sunday'; break;
			case 'Mon': $nom='Monday'; break;
			case 'Tue': $nom='Tuesday'; break;
			case 'Wed': $nom='Wednesday'; break;
			case 'Thu': $nom='Thursday'; break;
			case 'Fri': $nom='Friday'; break;
			case 'Sat': $nom='Saturday'; break;
		}
	}

	return $nom;
}


function jour($numdate) {
	$date_array = recup_date($numdate);
	if ($date_array)
		list($annee,$mois,$jour) = $date_array;
	else
		return '';
	if ($jour=="1") $jour="1er";
	return $jour;
}


function mois($numdate) {
	$date_array = recup_date($numdate);
	if ($date_array)
		list($annee,$mois,$jour) = $date_array;
	else
		return '';
	return $mois;
}


function annee($numdate) {
	$date_array = recup_date($numdate);
	if ($date_array)
		list($annee,$mois,$jour) = $date_array;
	else
		return '';
	return $annee;
}

function saison($numdate) {
	return affdate_base($numdate, 'saison');
}

function affdate($numdate) {
	return affdate_base($numdate, 'entier');
}

function affdate_court($numdate) {
	return affdate_base($numdate, 'court');
}

function affdate_mois_annee($numdate) {
	return affdate_base($numdate, 'mois_annee');
}

function nom_mois($numdate) {
	return affdate_base($numdate, 'mois');
}

function majuscules($texte) {
	$suite = htmlentities($texte);
	$suite = ereg_replace('&amp;', '&', $suite);
	$suite = ereg_replace('&lt;', '<', $suite); 
	$suite = ereg_replace('&gt;', '>', $suite); 
	$texte = '';
	if (ereg('^(.*)&([A-Za-z])([a-zA-Z]*);(.*)$', $suite, $regs)) {     
		$texte .= majuscules($regs[1]);
		$suite = $regs[4];
		$carspe = $regs[2];
		$accent = $regs[3];
		if (ereg('^(acute|grave|circ|uml|cedil|slash|caron|ring|tilde|elig)$', $accent))
			$carspe = strtoupper($carspe); 
		if ($accent == 'elig') $accent = 'Elig';
		$texte .= '&'.$carspe.$accent.';';
	}
	$texte .= strtoupper($suite);
	return $texte;
}

function justifier($letexte) {
	$letexte = eregi_replace("^<p([[:space:]][^>]*)?".">", "", trim($letexte));
	if ($letexte)
		$letexte = "<p align='justify'>".eregi_replace("<p([[:space:]][^>]*)?".">", "<p\\1 align='justify'>", $letexte);
	return $letexte;
}

function aligner_droite($letexte) {
	$letexte = eregi_replace("^<p([[:space:]][^>]*)?".">", "", trim($letexte));
	if ($letexte)
		$letexte = "<p align='right'>".eregi_replace("<p([[:space:]][^>]*)?".">", "<p\\1 align='right'>",$letexte);
	return $letexte;
}

function aligner_gauche($letexte) {
	$letexte = eregi_replace("^<p([[:space:]][^>]*)?".">", "", trim($letexte));
	if ($letexte)
		$letexte = "<p align='left'>".eregi_replace("<p([[:space:]][^>]*)?".">", "<p\\1 align='left'>",$letexte);
	return $letexte;
}

function centrer($letexte) {
	$letexte = eregi_replace("^<p([[:space:]][^>]*)?".">", "", trim($letexte));
	if ($letexte)
		$letexte = "<p align='center'>".eregi_replace("<p([[:space:]][^>]*)?".">", "<p\\1 align='center'>",$letexte);
	return $letexte;
}

function textebrut($letexte) {
	$letexte = ereg_replace("[\n\r]+", " ", $letexte);
	$letexte = eregi_replace("<(p|br)([[:space:]][^>]*)?".">", "\n\n", $letexte);
	$letexte = ereg_replace("^\n+", "", $letexte);
	$letexte = ereg_replace("\n+$", "", $letexte);
	$letexte = ereg_replace("\n +", "\n", $letexte);
	$letexte = ereg_replace("(<[^>]+>|&nbsp;| )+", " ", $letexte);
	return $letexte;
}

function couper($texte, $long) {
	$texte2 = substr($texte, 0, $long * 2); /* heuristique pour prendre seulement le necessaire */
	if (strlen($texte2) < strlen($texte)) $plus_petit = true;
	$texte = ereg_replace("\[([^\[]*)->([^]]*)\]","\\1", $texte2);

	// supprimer les notes
	$texte = ereg_replace("\[\[([^]]|\][^]])*\]\]", "", $texte);

	// supprimer les codes typos
	$texte = strtr($texte,"{}","  ");

	$texte2 = substr($texte." ", 0, $long);
	$texte2 = ereg_replace("([^[:space:]][[:space:]]+)[^[:space:]]*$", "\\1", $texte2);
	if ((strlen($texte2) + 3) < strlen($texte)) $plus_petit = true;
	if ($plus_petit) $texte2 .= ' (...)';
	return $texte2;
}


function ereg_remplace($cherche_tableau, $remplace_tableau, $texte) {
	global $flag_preg_replace;

	if ($flag_preg_replace) return preg_replace($cherche_tableau, $remplace_tableau, $texte);

	$n = count($cherche_tableau);

	for ($i = 0; $i < $n; $i++) {
		$texte = ereg_replace(substr($cherche_tableau[$i], 1, -1), $remplace_tableau[$i], $texte);
	}
	return $texte;
}


// correction typographique francaise
function typo_fr($letexte) {
	global $flag_preg_replace;
	global $flag_str_replace;

	// les "blancs durs" et les guillemets
	if ($flag_str_replace){
		$letexte = str_replace("&nbsp;","~",strtr($letexte,chr(160),"~"));
		$letexte = str_replace("&raquo;",chr(187),$letexte);
		$letexte = str_replace("&#187;", chr(187),$letexte);
		$letexte = str_replace("&laquo;",chr(171),$letexte);
		$letexte = str_replace("&#171;", chr(171),$letexte);
	} else {
		$letexte = ereg_replace("&nbsp;","~",strtr($letexte,chr(160),"~"));
		$letexte = ereg_replace("&(raquo|#187);",chr(187), $letexte);
		$letexte = ereg_replace("&(laquo|#171);",chr(171), $letexte);
	}

	$cherche1 = array(
		/* 2 */ 	'/((^|[^\#0-9a-zA-Z\&])[\#0-9a-zA-Z]*)\;/',
		/* 3 */		'/([:!?'.chr(187).'])/',
		/* 4 */		'/('.chr(171).'|(M(M?\.|mes?|r\.?)|[MnN]'.chr(176).') )/',
		/* 6 */		'/ +-,/'
	);
	$remplace1 = array(
		/* 2 */		'\1~;',
		/* 3 */		'~\1',
		/* 4 */		'\1~',
		/* 6 */		'~-,'
	);

	$letexte = ereg_remplace($cherche1, $remplace1, $letexte);
	$letexte = ereg_replace(" *~+ *", "~", $letexte);

	$cherche2 = array(
		'/(http|ftp|mailto)~:/',
		'/~/'
	);
	$remplace2 = array(
		'\1:',
		'&nbsp;'
	);

	$letexte = ereg_remplace($cherche2, $remplace2, $letexte);

	return ($letexte);
}

// Echappements
function echappe_html($letexte,$source) {

	// Echapper les <a href>
	$regexp_echap = "<a [^>]+>";
	while (eregi($regexp_echap, $letexte, $regs)) {
		$num_echap++;
		$les_echap[$num_echap] = $regs[0];
		$pos = strpos($letexte, $les_echap[$num_echap]);
		$letexte = substr($letexte,0,$pos)."___SPIP_$source$num_echap ___"
			.substr($letexte,$pos+strlen($les_echap[$num_echap]));
	}

	// Echapper les <html>...</ html>
	$regexp_echap = "<html>(([^<]|<[^/]|</[^h]|</h[^t]|</ht[^m]|</htm[^l]|<\/html[^>])*)<\/html>";
	while (eregi($regexp_echap, $letexte, $regs)) {
		$num_echap++;
		$les_echap[$num_echap] = $regs[1];
		$pos = strpos($letexte, $regs[0]);
		$letexte = substr($letexte,0,$pos)."___SPIP_$source$num_echap ___"
			.substr($letexte,$pos+strlen($regs[0]));
	}

	//
	// Echapper les <code>...</ code>
	//
	$regexp_echap = "<code>(([^<]|<[^/]|</[^c]|</c[^o]|</co[^d]|</cod[^e]|<\/code[^>])*)<\/code>";
	while (eregi($regexp_echap, $letexte, $regs)) {
		$num_echap++;
		$lecode = nl2br(htmlspecialchars($regs[1]));
		$lecode = ereg_replace("\t","&nbsp; &nbsp; &nbsp; &nbsp; ", $lecode);
		$les_echap[$num_echap] = "<tt><div align='left' class='spip_code'>".$lecode."</div></tt>\n";
		$pos = strpos($letexte, $regs[0]);
		$letexte = substr($letexte,0,$pos)."___SPIP_$source$num_echap ___"
			.substr($letexte,$pos+strlen($regs[0]));
	}

	return array($letexte, $les_echap);
}

// Traitement final des echappements
function echappe_retour($letexte, $les_echap, $source) {

	while(ereg("___SPIP_$source([0-9]+) ___",$letexte,$match)) {
		$lenum = $match[1];
		$cherche = $match[0];
		$pos = strpos($letexte, $cherche);
		$letexte = substr($letexte, 0, $pos). $les_echap[$lenum] . substr($letexte, $pos + strlen($cherche));
	}

	return $letexte;
}

function typo($letexte) {
	global $lang;

	list($letexte, $les_echap) = echappe_html($letexte, "SOURCETYPO");

	if ($lang == 'fr')
		$letexte = typo_fr($letexte);

	// corrige les caracteres degoutants
	// 145,146,180 = simple quote ; 147,148 = double quote
	$letexte = strtr($letexte,chr(145).chr(146).chr(180).chr(147).chr(148), "'''".'""');

	$letexte = echappe_retour($letexte, $les_echap, "SOURCETYPO");

	return $letexte;
}

//
// Nettoie un texte, traite les raccourcis spip, la typo, etc.
//
function traiter_raccourcis($letexte, $les_echap=false) {
	global $puce;
	global $debut_intertitre, $fin_intertitre;
	global $id_article;
	global $compt_note;
	global $les_notes;
	global $ouvre_ref;
	global $ferme_ref;
	global $ouvre_note;
	global $ferme_note;
	global $flag_strpos_3, $flag_preg_replace, $flag_str_replace;

	// Harmoniser les retours chariot
	$letexte = ereg_replace ("\r\n?", "\n",$letexte);

	// echapper les <a href>, <html>...< /html>, <code>...< /code>
	if (! $les_echap)
		list($letexte, $les_echap) = echappe_html($letexte, "SOURCEPROPRE");

	// Corriger HTML
	$letexte = eregi_replace("</?p>","\n\n\n",$letexte);

	//
	// Notes de bas de page
	//
	$regexp = "\[\[(([^]]|[^]]\][^]])*)\]\]";
	/* signifie : deux crochets ouvrants, puis pas-crochet-fermant ou
		crochet-fermant entoure de pas-crochets-fermants (c'est-a-dire
		tout sauf deux crochets fermants), puis deux fermants */
	while (ereg($regexp, $letexte, $regs)){
		$note_texte = $regs[1];
		$num_note=false;
		if (ereg("^ *<([^>]*)>",$note_texte,$regs)){ // note pas auto ?
			$num_note=$regs[1];
			$note_texte = ereg_replace ("^ *<([^>]*)>","",$note_texte);
		} else { // note auto
			$compt_note++;
			$num_note=$compt_note;
		}
		if ($num_note){
			$insert = "$ouvre_ref<a href='#nb$num_note' name='nh$num_note' class='spip_note'>$num_note</a>$ferme_ref";
			if ($note_texte)
				$les_notes .= "$ouvre_note<a href='#nh$num_note' name='nb$num_note' class='spip_note'>$num_note</a>$ferme_note".traiter_raccourcis(trim($note_texte), $les_echap)."<p class='spip_note'>\n";
		} else {
			$insert = '';
			if ($note_texte)
				$les_notes .= traiter_raccourcis(trim($note_texte), $les_echap)."<p class='spip_note'>\n";
		}
		$letexte = implode($insert, split($regexp, $letexte, 2));
	}

	//
	// Raccourcis liens
	//
	$regexp = "\[([^][]*)->([^]]*)\]";
	$texte_a_voir = $letexte;
	$texte_vu = '';
	while (ereg($regexp, $texte_a_voir, $regs)){
		$lien_texte = typo($regs[1]);
		$lien_url = trim($regs[2]);
		$compt_liens++;
		$lien_interne = false;
		if (ereg('^(art(icle)?|rub(rique)?|br(.ve)?|aut(eur)?|mot)? *([[:digit:]]+)$', $lien_url, $match)) {
			// Traitement des liens internes
			$id_lien = $match[6];
			$type_lien = $match[1];
			$lien_interne=true;
			switch (substr($type_lien, 0, 2)) {
				case 'ru':
					$lien_url = generer_url_rubrique($id_lien);
					if (!$lien_texte) {
						$req = "select titre from spip_rubriques where id_rubrique=$id_lien";
						$row = @mysql_fetch_array(@mysql_query($req));
						$lien_texte = $row['titre'];
					}
					break;
				case 'br':
					$lien_url = generer_url_breve($id_lien);
					if (!$lien_texte) {
						$req = "select titre from spip_breves where id_breve=$id_lien";
						$row = @mysql_fetch_array(@mysql_query($req));
						$lien_texte = $row['titre'];
					}
					break;
				case 'au':
					$lien_url = generer_url_auteur($id_lien);
					if (!$lien_texte) {
						$req = "select nom from spip_auteurs where id_auteur = $id_lien";
						$row = @mysql_fetch_array(@mysql_query($req));
						$lien_texte = $row['nom'];
					}
					break;
				case 'mo':
					$lien_url = generer_url_mot($id_lien);
					if (!$lien_texte) {
						$req = "select titre from spip_mots where id_mot=$id_lien";
						$row = @mysql_fetch_array(@mysql_query($req));
						$lien_texte = $row['titre'];
					}
					break;
				default:
					$lien_url = generer_url_article($id_lien);
					if (!$lien_texte) {
						$req = "select titre from spip_articles where id_article=$id_lien";
						$row = @mysql_fetch_array(@mysql_query($req));
						$lien_texte = $row['titre'];
					}
					break;
			}
		}

		// feuilles de style
		$class_lien = ($lien_interne ? 'in' : 'out');

		if ((!$lien_texte) and (!$lien_interne)) {
			$lien_texte = ereg_replace('"', '', $lien_url);
			$class_lien = "url";
		}

		$insert = "<a href=\"$lien_url\" class=\"spip_$class_lien\">$lien_texte</a>";
		$zetexte = split($regexp,$texte_a_voir,2);

		// typo en-dehors des notes
		$texte_vu .= typo($zetexte[0]).$insert;
		$texte_a_voir = $zetexte[1];
	}
	$letexte = $texte_vu.typo($texte_a_voir); // typo de la queue du texte

	//
	// Insertion d'images utilisateur
	//
	while(eregi("<IMG([0-9]+)\|([^\>]*)>",$letexte,$match)) {
		$letout = quotemeta($match[0]);
		$letout = ereg_replace("\|","\|",$letout);
		$lenum = $match[1];
		$lalign = $match[2];
		$rempl = integre_image($id_article, $lenum, $lalign);
		$letexte = ereg_replace($letout, $rempl, $letexte);
	}

	//
	// Tableaux
	//
	$letexte = ereg_replace("^\n{0,2}\|", "\n\n\n|", $letexte);
	$letexte = ereg_replace("\|\n{0,2}$", "|\n\n\n", $letexte);
	
	$tableBeginPos = strpos($letexte, "\n\n\n|");
	$tableEndPos = strpos($letexte, "|\n\n\n");
	while (is_integer($tableBeginPos) && is_integer($tableEndPos) && $tableBeginPos < $tableEndPos) {
		$textBegin = substr($letexte, 0, $tableBeginPos);
		$textTable = substr($letexte, $tableBeginPos + 3, $tableEndPos - $tableBeginPos - 1);
		$textEnd = substr($letexte, $tableEndPos + 4);
		
		$newTextTable = "\n<p><table class=\"spip\">";
		$rowId = 0;
		$lineEnd = strpos($textTable, "|\n");
		while (is_integer($lineEnd)) {
			$rowId++;
			$row = substr($textTable, 0, $lineEnd);
			$textTable = substr($textTable, $lineEnd + 2);
			if ($rowId == 1 && ereg("^(\|\{\{[^}]+\}\})+$", $row)) {
				$newTextTable .= '<tr class="row_first">';
			} else {
				$newTextTable .= '<tr class="row_'.($rowId % 2 ? 'odd' : 'even').'">';
			}
			$newTextTable .= ereg_replace("\|([^\|]+)", "<td>\\1</td>", $row);
			$newTextTable .= '</tr>';
			$lineEnd = strpos($textTable, "|\n");
		}
		$newTextTable .= "</table>\n<p>";
		
		$letexte = $textBegin . $newTextTable . $textEnd;

		$tableBeginPos = strpos($letexte, "\n\n\n|");
		$tableEndPos = strpos($letexte, "|\n\n\n");
	}
	
	//
	// Ensemble de remplacements implementant le systeme de mise
	// en forme (paragraphes, raccourcis...)
	//
	// ATTENTION : si vous modifiez cette partie, modifiez les DEUX
	// alternatives (if/else) de faon similaire. Merci.
	//
	$letexte = trim($letexte);
	if ($flag_str_replace && !$flag_preg_replace) {
		$letexte = ereg_replace("\n(-{4,}|_{4,})", "\n<hr class=\"spip\">\n", $letexte);
		$letexte = ereg_replace("^-", "$puce ", $letexte);
		$letexte = str_replace("\n-", "\n<br>$puce ",$letexte);
		$letexte = ereg_replace("(( *)\n){2,}", "\n<p>", $letexte);
		$letexte = str_replace("{{{", $debut_intertitre, $letexte);
		$letexte = str_replace("}}}", $fin_intertitre, $letexte);
		$letexte = str_replace("{{", "<b class=\"spip\">", $letexte);
		$letexte = str_replace("}}", "</b>", $letexte);
		$letexte = str_replace("{", "<i class=\"spip\">", $letexte);
		$letexte = str_replace("}", "</i>", $letexte);
		$letexte = eregi_replace("(<br>)+(<p>|<br>)", "\n<p>", $letexte);
		$letexte = str_replace("<p>", "<p class=\"spip\">", $letexte);
	}
	else {
		$cherche1 = array(
			/* 1 */		"/\n(----+|____+)/",
			/* 2 */		"/^-/",
			/* 3 */		"/\n-/",
			/* 4*/		"/(( *)\n){2,}/",
			/* 5 */		"/\{\{\{/",
			/* 6 */		"/\}\}\}/",
			/* 7 */		"/\{\{/",
			/* 8 */		"/\}\}/",
			/* 9 */		"/\{/",
			/* 10 */	"/\}/",
			/* 11 */	"/(<br>){2,}/",
			/* 12 */	"/<p>([\n]*)(<br>)+/",
			/* 13 */	"/<p>/"
		);
		$remplace1 = array(
			/* 1 */ 	"\n<hr class=\"spip\">\n",
			/* 2 */ 	"$puce ",
			/* 3 */ 	"\n<br>$puce ",
			/* 4 */		"\n<p>",
			/* 5 */ 	"$debut_intertitre",
			/* 6 */ 	"$fin_intertitre",
			/* 7 */ 	"<b class=\"spip\">",
			/* 8 */ 	"</b>",
			/* 9 */ 	"<i class=\"spip\">",
			/* 10 */ 	"</i>",
			/* 11 */ 	"\n<p>",
			/* 12 */ 	"\n<p>",
			/* 13 */	"<p class=\"spip\">"
		);
		$letexte = ereg_remplace($cherche1, $remplace1, $letexte);
	}

	// reinsere les echappements
	$letexte = echappe_retour($letexte, $les_echap, "SOURCEPROPRE");
	$les_notes = echappe_retour($les_notes, $les_echap, "SOURCEPROPRE");

	return $letexte;
}


function propre($letexte) {
	return interdire_scripts(traiter_raccourcis(trim($letexte)));
}

?>
