<?

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_VERSION")) return;
define("_ECRIRE_INC_VERSION", "1");


//
// Infos sur l'hebergeur
//

$hebergeur = '';
$login_hebergeur = '';
$os_serveur = '';

// Multimania
if (ereg('^(.*)\.multimania\.(com|net|fr)$', $HTTP_X_HOST, $regs)) {
	$hebergeur = 'multimania';
	if ($regs[1] == 'www')
		ereg('^/([^/]*)/', $REQUEST_URI, $regs);
	$login_hebergeur = $regs[1].'_db';
}
// Altern
else if (ereg('altern\.com$', $SERVER_NAME)) {
	$hebergeur = 'altern';
	ereg('([^.]*\.[^.]*)$', $HTTP_HOST, $regs);
	$login_hebergeur = ereg_replace('[^a-zA-Z0-9]', '_', $regs[1]);
}
// Free
else if (ereg('^/([^/]*)\.free.fr/', $REQUEST_URI, $regs)) {
	$hebergeur = 'free';
	$login_hebergeur = $regs[1];
}
// Online
else if (ereg('pro\.proxad\.net$', $HTTP_HOST) || ereg('pro\.proxad\.net$', $SERVER_NAME)) {
	$hebergeur = 'online';
}

if (eregi('\(Win', $SERVER_SOFTWARE))
	$os_serveur = 'windows';

// Droits d'acces maximum par defaut
@umask(0);


//
// Infos sur le fichier courant
//

// Compatibilite avec serveurs ne fournissant pas $REQUEST_URI
if (!$REQUEST_URI) {
	$REQUEST_URI = $PHP_SELF;
	if ($QUERY_STRING) $REQUEST_URI .= '?'.$QUERY_STRING;
}

if (!$PATH_TRANSLATED) {
	if ($SCRIPT_FILENAME) $PATH_TRANSLATED = $SCRIPT_FILENAME;
	else if ($DOCUMENT_ROOT && $SCRIPT_URL) $PATH_TRANSLATED = $DOCUMENT_ROOT.$SCRIPT_URL;
}

//
// Infos de version PHP
//

$php_version = explode('.', phpversion());
$php_version_maj = (int) $php_version[0];
$php_version_med = (int) $php_version[1];
if (ereg('([0-9]+)', $php_version[2], $match)) $php_version_min = (int) $match[1];

$flag_function_exists = ($php_version_maj > 3 OR $php_version_min >= 7);
$flag_ignore_user_abort = ($php_version_maj > 3 OR $php_version_min >= 7);
$flag_levenshtein = ($php_version_maj >= 4);
$flag_mt_rand = ($php_version_maj > 3 OR $php_version_min >= 6);
$flag_str_replace = ($php_version_maj > 3 OR $php_version_min >= 8);
$flag_strpos_3 = (@strpos('baba', 'a', 2) == 3);

if ($flag_function_exists) {
	$gz_exists = function_exists("gzopen");
	$flag_preg_replace = function_exists("preg_replace");
	$flag_crypt = function_exists("crypt");
}
else {
	$gz_exists = false;
	$flag_preg_replace = false;
	$flag_crypt = true; // la non-existence de crypt est une exception
}


//
// Infos de config PHP
//

if (ereg("^Apache", $SERVER_SOFTWARE) AND ereg(" PHP", $SERVER_SOFTWARE) AND !$REDIRECT_SCRIPT_URL)
	$php_module = true;

$f = @fopen('../inc-calcul.php3', 'r');
$open_basedir = ($f != 0);
@fclose($f);

function tester_upload() {
	global $hebergeur;
	$test_upload = true;
	if ($hebergeur == 'multimania') $test_upload = false;
	return $test_upload;
}

function tester_accesdistant() {
	global $hebergeur;
	$test_acces = true;
	if ($hebergeur == 'multimania') $test_acces = false;
	return $test_acces;
}


//
// Version courante de SPIP
// Stockee sous forme de nombre decimal afin de faciliter les comparaisons
// (utilise pour les modifs de la base de donnees)
//

$spip_version = 1.206; // version de la base
$spip_version_affichee = "1.2 beta 7"; // version de SPIP



function analyser_version($version) {
	ereg('([0-9]*)((\.([0-9]+))(\.([0-9]+))?)?([a-zA-Z]+)?', $version, $regs);
	$result[0] = (int) $regs[1];
	$result[1] = (int) $regs[4];
	$result[2] = (int) $regs[6];
	$result[3] = $regs[7];
	return $result;
}

// Retourne vrai si la version actuelle est
// anterieure a celle passee en parametre

function version_anterieure($version) {
	global $spip_version;
	$sv = analyser_version($spip_version);
	$v = analyser_version($version);
	if ($sv[0] != $v[0]) return ($sv[0] < $v[0]);
	if ($sv[1] != $v[1]) return ($sv[1] < $v[1]);
	if ($sv[2] != $v[2]) return ($sv[2] < $v[2]);
	return ($sv[3] < $v[3]);
}

?>