<?

//
// Ce fichier ne sera execute qu'une fois
if (defined("_INC_CALCUL")) return;
define("_INC_CALCUL", "1");


// Cette fonction est avant les include(...) car elle est requise par inc_texte.php3

function integre_image($id_article, $lenum, $lalign) {
	$racine = "IMG/art$id_article-$lenum";
	if (file_exists("$racine.gif")) {
		$image = "$racine.gif";
	} elseif (file_exists("$racine.jpg")) {
		$image = "$racine.jpg";
	} elseif (file_exists("$racine.png")) {
		$image = "$racine.png";
	}
	
	if ($image) {
		$taille = getimagesize($image);
		$largeur = $taille[0];
		$hauteur = $taille[1];
		return "<IMG SRC='$image' ALIGN='$lalign' WIDTH=$largeur HEIGHT=$hauteur HSPACE=3 VSPACE=3 BORDER=0>";
	} else {
		return "";
	}
}


function interdire_scripts($source){
	$source = eregi_replace("<(\%|\?|( *)script)", "&lt;\\1", $source);
	return $source;
}


include ("ecrire/inc_index.php3");
include ("ecrire/inc_texte.php3");
include ("ecrire/enlettres.php3");

include ("inc-forum.php3");
include ("inc-urls.php3");

if (file_exists("mes_fonctions.php3")) include ("mes_fonctions.php3");


function TesterPage($laPage,$leChemin,$laRecherche,$laMethode){

	$fp = fsockopen($laPage, 80, $errno, $errstr);
	if($fp){
		fputs($fp,"$laMethode $leChemin?$laRecherche HTTP/1.0\nHost: $laPage\n\n");
		while(!feof($fp)) {
			$leRetour=fgets($fp,128);
			$resultat .= $leRetour;
		}
		fclose($fp);
				
		return $resultat;
	}
}

function syndic_a_jour($la_query,$now_id_syndic){

	$la_query=parse_url($la_query);
	$le_retour=TesterPage($la_query[host],$la_query[path],$la_query[query],"GET");


	if (strlen($le_retour)>10){

		$i=0;
		$item="";
		while(strpos($le_retour,"<item>")>0){
			$debut_item=strpos($le_retour,"<item>");
			$fin_item=strpos($le_retour,"</item>")+strlen("</item>");
			$item[$i]=substr($le_retour,$debut_item,$fin_item-$debut_item);

			$debut_texte=substr($le_retour,"0",$debut_item);
			$fin_texte=substr($le_retour,$fin_item,strlen($le_retour));
			$le_retour=$debut_texte.$fin_texte;
			$i++;
		}
		if (count($item)>1){
			for($i=0;$i<count($item);$i++){
				ereg("<title>(.*)</title>",$item[$i],$match);
				$le_titre=addslashes($match[1]);
				$match="";
				ereg("<link>(.*)</link>",$item[$i],$match);
				$le_lien=$match[1];
				$match="";
				ereg("<date>(.*)</date>",$item[$i],$match);
				$la_date=$match[1];
				$match="";
				ereg("<auteurs>(.*)</auteurs>",$item[$i],$match);
				$les_auteurs=addslashes($match[1]);
				$match="";
				if (strlen($la_date)<4)$la_date=date("Y-m-j H:i:00");
								
				$query_deja="SELECT * FROM spip_syndic_articles WHERE url=\"$le_lien\" AND id_syndic=$now_id_syndic";
				$result_deja=mysql_query($query_deja);
				if (mysql_num_rows($result_deja)==0){
					$query_syndic="INSERT INTO spip_syndic_articles SET id_syndic=\"$now_id_syndic\", titre=\"$le_titre\", url=\"$le_lien\", date=\"$la_date\", lesauteurs=\"$les_auteurs\"";
					$result_syndic=mysql_query($query_syndic);
				}
			}
		}
	}
}


function calculer_rubriques_publiques()
{
	global $rubriques_publiques;
	$rubriques_publiques = "";
	
	$post_dates = lire_meta("post_dates");

	if ($post_dates != "non") {
		$query = "SELECT DISTINCT id_rubrique FROM spip_articles WHERE statut = 'publie'";
	}
	else {
		$query = "SELECT DISTINCT id_rubrique FROM spip_articles WHERE statut = 'publie' AND date < NOW()";
	}
	for (;;) {
		$result = mysql_query($query);
		unset($rubriques);
		while ($row = mysql_fetch_array($result)) {
			if ($row[0]) $rubriques[] = $row[0];
		}
		if (!$rubriques) break;
		$rubriques = join(",", $rubriques);
		if ($rubriques_publiques) $rubriques_publiques .= ",$rubriques";
		else $rubriques_publiques = $rubriques;
		$query = "SELECT DISTINCT id_parent FROM spip_rubriques WHERE (id_rubrique IN ($rubriques)) AND (id_parent NOT IN ($rubriques_publiques))";
	}
}


function image_rubrique($id_rubrique){
	if (file_exists("IMG/rubon$id_rubrique.gif")){
		$rubon="rubon$id_rubrique.gif";
	}
	if (file_exists("IMG/rubon$id_rubrique.jpg")){
		$rubon="rubon$id_rubrique.jpg";
	}
	if (file_exists("IMG/rubon$id_rubrique.png")){
		$rubon="rubon$id_rubrique.png";
	}
	if (strlen($rubon)>5){
		if (file_exists("IMG/ruboff$id_rubrique.gif")){
			$ruboff="ruboff$id_rubrique.gif";
		}
		if (file_exists("IMG/ruboff$id_rubrique.jpg")){
			$ruboff="ruboff$id_rubrique.jpg";
		}
		if (file_exists("IMG/ruboff$id_rubrique.png")){
			$ruboff="ruboff$id_rubrique.png";
		}
	}	
	$image[0]=$rubon;
	$image[1]=$ruboff;	
	if ($id_rubrique>0 AND strlen($rubon)<5){
		$nouv_query="SELECT * FROM spip_rubriques WHERE id_rubrique='$id_rubrique'";
	 	$nouv_result=mysql_query($nouv_query);

		while($row=mysql_fetch_array($nouv_result)){
			$id_parent=$row[1];
		}			
		$image=image_rubrique($id_parent);
	}
	
	return $image;

}


function image_article($id_article){
	if (file_exists("IMG/arton$id_article.gif")){
		$arton="arton$id_article.gif";
	}
	if (file_exists("IMG/arton$id_article.jpg")){
		$arton="arton$id_article.jpg";
	}
	if (file_exists("IMG/arton$id_article.png")){
		$arton="arton$id_article.png";
	}
	if (strlen($arton)>5){
		if (file_exists("IMG/artoff$id_article.gif")){
			$artoff="artoff$id_article.gif";
		}
		if (file_exists("IMG/artoff$id_article.jpg")){
			$artoff="artoff$id_article.jpg";
		}
		if (file_exists("IMG/artoff$id_article.png")){
			$artoff="artoff$id_article.png";
		}
	}	
	$image[0]=$arton;
	$image[1]=$artoff;	
	
	return $image;
}


function image_auteur($id_article){
	if (file_exists("IMG/auton$id_article.gif")){
		$arton="auton$id_article.gif";
	}
	if (file_exists("IMG/auton$id_article.jpg")){
		$arton="auton$id_article.jpg";
	}
	if (file_exists("IMG/auton$id_article.png")){
		$arton="auton$id_article.png";
	}
	if (strlen($arton)>5){
		if (file_exists("IMG/autoff$id_article.gif")){
			$artoff="autoff$id_article.gif";
		}
		if (file_exists("IMG/autoff$id_article.jpg")){
			$artoff="autoff$id_article.jpg";
		}
		if (file_exists("IMG/autoff$id_article.png")){
			$artoff="autoff$id_article.png";
		}
	}	
	$image[0]=$arton;
	$image[1]=$artoff;	
	
	return $image;
}


function image_breve($id_article){
	if (file_exists("IMG/breveon$id_article.gif")){
		$arton="breveon$id_article.gif";
	}
	if (file_exists("IMG/breveon$id_article.jpg")){
		$arton="breveon$id_article.jpg";
	}
	if (file_exists("IMG/breveon$id_article.png")){
		$arton="breveon$id_article.png";
	}
	if (strlen($arton)>5){
		if (file_exists("IMG/breveoff$id_article.gif")){
			$artoff="breveoff$id_article.gif";
		}
		if (file_exists("IMG/breveoff$id_article.jpg")){
			$artoff="breveoff$id_article.jpg";
		}
		if (file_exists("IMG/breveoff$id_article.png")){
			$artoff="breveoff$id_article.png";
		}
	}	
	$image[0]=$arton;
	$image[1]=$artoff;	
	
	return $image;
}



/* renvoie le html pour afficher le logo, avec ou sans survol, avec ou sans lien, etc. */
function affiche_logos($arton, $artoff, $lien, $align) {
	global $num_survol;
	$num_survol++;
	if (strlen($arton) > 5) {
		$imgsize = @getimagesize("IMG/$arton");
		$milieu = "<IMG SRC='IMG/$arton' ALIGN='$align' ".
			" NAME='image$num_survol' ".$imgsize[3]." BORDER='0' ALT='[logo]'".
			" HSPACE=3 VSPACE=3>";

		if (strlen($artoff) > 5) {
			if (strlen($lien)>1) {
				$afflien="HREF='$lien'";
			}
			else {
				$afflien="HREF='#'";
			}
			$milieu = "<A $afflien onMouseOver=\"image$num_survol.src=".
				"'IMG/$artoff'\" onMouseOut=\"image$num_survol.src=".
				"'IMG/$arton'\">$milieu</A>";
		}
		elseif(strlen($lien) > 2) {
			$milieu = "<A HREF='$lien'>$milieu</A>";
		}
	}else{
		$milieu="";
	}

	return $milieu;
}


function parent($id_rubrique) {
	$query="SELECT * FROM spip_rubriques WHERE id_rubrique='$id_rubrique'";
	$result=mysql_query($query);
	while($row=mysql_fetch_array($result)){
		$id_parent=$row[1];
	}
	
	if ($id_rubrique>0){			
		return parent($id_parent)."-".$id_rubrique;
	}
}



//////////////////////////////////////////////////////////////////////////////
//
//              Parsing des squelettes
//
//////////////////////////////////////////////////////////////////////////////


class Texte {
	var $type = 'texte';
	var $texte;
}

class Champ {
	var $type = 'champ';
	var $nom_champ, $id_champ;
	var $cond_avant, $cond_apres; // tableaux d'objets
	var $fonctions;
	var $id_boucle, $id_row, $code; // valeurs cachees
}

class Boucle {
	var $type = 'boucle';
	var $id_boucle, $id_parent, $recursion;
	var $avant, $cond_avant, $milieu, $cond_apres, $cond_altern, $apres; // tableaux d'objets
	var $commande;
	var $requete;
	var $type_requete;
	var $separateur;
	var $doublons;
	var $row, $num_rows; // resultat de la requete
	var $partie, $total_parties;
	var $compteur_boucle, $total_boucle;
}



function parser_boucle($texte) {
	global $rubriques_publiques;
	global $recherche;

	//
	// Detecter et parser la boucle
	//

	$p = strpos($texte, '<BOUCLE');
	if (!$p && (substr($texte, 0, strlen('<BOUCLE')) != '<BOUCLE')) {
		$result = new Texte;
		$result->texte = $texte;
		return $result;
	}

	$result = new Boucle;

	$debut = substr($texte, 0, $p);
	$milieu = substr($texte, $p);

	if (!ereg("(<BOUCLE([0-9]+|_[-_.a-zA-Z0-9]*) *(\([^)]*\)( *\{[^}]*\})*) *>)", $milieu, $match)) {
		die ("<h2>Syntaxe boucle incorrecte :</h2>".htmlspecialchars($milieu));
	}

	$commande = $match[1];
	$id_boucle = $match[2];
	$suite_commande = $match[3];


	//
	// Decomposer les structures conditionnelles
	//

	$s = "<B$id_boucle>";
	$p = strpos($debut, $s);
	if ($p || (substr($debut, 0, strlen($s)) == $s)) {
		$cond_avant = substr($debut, $p + strlen($s));
		$debut = substr($debut, 0, $p);
	}

	$milieu = substr($milieu, strlen($commande));
	$s = "</BOUCLE$id_boucle>";
	$p = strpos($milieu, $s);
	if ((!$p) && (substr($milieu, 0, strlen($s)) != $s)) die("<h2>BOUCLE$id_boucle: tag fermant manquant</h2>");

	$fin = substr($milieu, $p + strlen($s));
	$milieu = substr($milieu, 0, $p);

	$s = "</B$id_boucle>";
	$p = strpos($fin, $s);
	if ($p || (substr($fin, 0, strlen($s)) == $s)) {
		$cond_fin = substr($fin, 0, $p);
		$fin = substr($fin, $p + strlen($s));
	}

	$s = "<//B$id_boucle>";
	$p = strpos($fin, $s);
	if ($p || (substr($fin, 0, strlen($s)) == $s)) {
		$cond_altern = substr($fin, 0, $p);
		$fin = substr($fin, $p + strlen($s));
	}


	//
	// Parser la commande de la boucle
	//

	if (ereg('\(([^)]*)\)', $suite_commande, $regs)) {
		$_type = $regs[1];
		$s = "($_type)";
		$p = strpos($suite_commande, $s);

		// Exploser les parametres
		$params = substr($suite_commande, $p + strlen($s));
		if (ereg('^ *\{(.*)\} *$', $params, $match)) $params = $match[1];
		$params = split('\} *\{', $params);
		$type = strtolower($_type);

		//
		// Type boucle (recursion)
		//
		if (substr($type, 0, 6) == 'boucle') {
			$requete = substr($_type, 6);
			$type = 'boucle';
		}
		else {
			//
			// Initialisation separee par type
			//
			switch($type) {
			case 'articles':
				$table = "articles";
				$req_from[] = "spip_articles AS $table";
				$id_objet = "id_article";
				break;

			case 'auteurs':
				$table = "auteurs";
				$req_from[] = "spip_auteurs AS $table";
				$id_objet = "id_auteur";
				break;

			case 'breves':
				$table = "breves";
				$req_from[] = "spip_breves AS $table";
				$id_objet = "id_breve";
				$col_date = "date_heure";
				break;

			case 'forums':
				$table = "forums";
				$req_from[] = "spip_forum AS $table";
				$id_objet = "id_forum";
				$col_date = "date_heure";
				break;

			case 'signatures':
				$table = "signatures";
				$req_from[] = "spip_signatures AS $table";
				$id_objet = "id_signature";
				$col_date = "date_time";
				break;

			case 'mots':
				$table = "mots";
				$req_from[] = "spip_mots AS $table";
				$id_objet = "id_mot";
				$req_where[] = "$table.titre<>'kawax'";
				break;

			case 'rubriques':
				$table = "rubriques";
				$req_from[] = "spip_rubriques AS $table";
				$id_objet = "id_rubrique";
				break;

			case 'syndication':
				$table = "syndic";
				$req_from[] = "spip_syndic AS $table";
				$id_objet = "id_syndic";
				break;

			case 'syndic_articles':
				$table = "articles";
				$req_from[] = "spip_syndic_articles AS $table";
				$req_from[] = "spip_syndic AS source";
				$req_where[] = "$table.id_syndic=source.id_syndic";
				$id_objet = "id_syndic_article";
				break;
			}
			if ($table) {
				if ($type == 'articles') {
					$s = "$table.id_article,$table.id_rubrique,$table.id_secteur,$table.surtitre,$table.titre,$table.soustitre,$table.date,$table.date_redac,$table.visites,$table.statut,$table.accepter_forum";
					if (ereg('\#(TEXTE|INTRODUCTION)', $milieu)) {
						$s .= ",$table.texte";
					}
					if (ereg('\#(CHAPO|INTRODUCTION)', $milieu)) {
						$s .= ",$table.chapo";
					}
					if (ereg('\#(DESCRIPTIF)', $milieu)) {
						$s .= ",$table.descriptif";
					}
					if (ereg('\#(PS)', $milieu)) {
						$s .= ",$table.ps";
					}
					$req_select[] = $s;
				}
				else $req_select[] = "$table.*";
			}
			if (!$col_date) $col_date = "date";

			//
			// Parametres : premiere passe
			//
			unset($params2);
			if ($params) {
				reset($params);
				while (list(, $param) = each($params)) {
					$param = trim($param);
					if ($param == 'exclus') {
						$req_where[] = "$table.$id_objet!=\$$id_objet";
					}
					else if ($param == 'tout' OR $param == 'plat') {
						$$param = true;
					}
					else if ($param == 'unique' OR $param == 'doublons') {
						$doublons = 'oui';
						$req_where[] = "$table.$id_objet NOT IN (\$id_doublons[$type])";
					}
					else if (ereg('"([^"]*)"', $param, $match)) {
						$separateur = $match[1];
					}
					else if (ereg('^([0-9]+),([0-9]*)', $param, $match)) {
						$req_limit = $match[1].','.$match[2];
					}
					else if (ereg('^debut([^,]+),([0-9]*)$', $param, $match)) {
						$debut_lim = "debut".$match[1];
						global $$debut_lim;
						$debut_lim = $$debut_lim;
						if (!$debut_lim) $debut_lim = 0;
						$req_limit = $debut_lim.','.$match[2];
					}
					else if (ereg('^([0-9]+)/([0-9]+)$', $param, $match)) {
						$partie = $match[1];
						$total_parties = $match[2];
					}
					else if ($param == 'recherche') {
						global $hash_recherche;
						$req_from[] = "spip_index_$type AS idx";
						$req_select[] = "SUM(idx.points) AS points";
						$req_where[] = "idx.$id_objet=$table.$id_objet";
						$req_group = " GROUP BY $table.$id_objet";

						if (!$hash_recherche) {
							$s = nettoyer_chaine_indexation(urldecode($recherche));
							$regs = separateurs_indexation();
							$s = split("[$regs]+", $s);
	
							unset($dico);
							unset($h);
							while (list(, $val) = each($s)) {
								if (strlen($val) > 3) {
									$dico[] = 'dico LIKE "'.$val.'%"';
								}
							}
							if ($dico) {
								// le hex est indispensable : apparemment bug de mysql
								// sur l'output decimal 64 bits (a cause du unsigned ?)
								$query2 = "SELECT HEX(hash) FROM spip_index_dico WHERE ".join(' OR ', $dico);
								$result2 = mysql_query($query2);
								while ($row2 = mysql_fetch_array($result2)) {
									$h[] = '0x'.$row2[0];
								}
							}
							if ($h) $hash_recherche = join(',', $h);
						}
						if ($hash_recherche)
							$req_where[] = "idx.hash IN ($hash_recherche)";
						else
							$req_where[] = "idx.hash=0";
					}
					else $params2[] = $param;
				}
			}
			$params = $params2;

			//
			// Parametres : deuxieme passe
			//
			if ($params) {
				reset($params);
				while (list(, $param) = each($params)) {

					// Classement par ordre inverse
					if ($param == 'inverse') {
						if ($req_order) $req_order .= ' DESC';
					}
	
					// Special rubriques
					else if ($param == 'meme_parent') {
						$req_where[] = "$table.id_parent=\$id_parent";
					}
					else if ($param == 'racine') {
						$req_where[] = "$table.id_parent=0";
					}
	
					// Restriction de valeurs (implicite ou explicite)
					else if (ereg('^([a-zA-Z_]+) *((<=?|>=?|==?) *([^<>=! ]*))?$', $param, $match)) {
						// Variable comparee
						$col = $match[1];
						$col_table = $table;

						// Valeur de comparaison
						if ($match[2])
							$val = $match[4];
						else {
							$val = $match[1];
							if ($val == 'id_parent')
								$val = $id_objet;
							else if ($type == 'rubriques' AND $val == 'id_enfant')
								$val = 'id_parent';
							$val = '$'.$val;
						}
	
						// Liens entre articles et auteurs/mots
						if ($type == 'articles' AND ($col == 'id_auteur' OR $col == 'id_mot')) {
							$col_table = 'spip_'.substr($col, 3).'s_articles';
							$req_from[] = $col_table;
							$req_where[] = "$table.$id_objet=$col_table.$id_objet";
							$req_group = " GROUP BY $table.$id_objet";
							$flag_lien = true;
						}
						else if	(($type == 'auteurs' OR $type == 'mots') AND $col == 'id_article')
						{
							$col_table = 'spip_'.$type.'_articles';
							$req_from[] = $col_table;
							$req_where[] = "$table.$id_objet=$col_table.$id_objet";
							$req_group = " GROUP BY $table.$id_objet";
							$flag_lien = true;
						}
						else if ($type == 'syndic_articles')
							$col_table = 'source';
						else if ($type == 'rubriques' AND $col == 'id_enfant')
							$col = 'id_rubrique';
						else if (($type == 'breves' OR $type == 'forums') AND $col == 'id_secteur')
							$col = 'id_rubrique';
						// Variables particulieres pour la date
						else if ($col == 'date')
							$col = $col_date;
						else if ($col == 'mois') {
							$col = "MONTH($table.$col_date)";
							$col_table = '';
						}
						else if ($col == 'mois_redac') {
							$col = "MONTH($table.date_redac)";
							$col_table = '';
						}
						else if ($col == 'annee') {
							$col = "YEAR($table.$col_date)";
							$col_table = '';
						}
						else if ($col == 'annee_redac') {
							$col = "YEAR($table.date_redac)";
							$col_table = '';
						}
						else if ($col == 'age') {
							$col = "(TO_DAYS(now()) - TO_DAYS($table.$col_date))";
							$col_table = '';
						}
						else if ($col == 'age_redac') {
							$col = "(TO_DAYS(now()) - TO_DAYS($table.date_redac))";
							$col_table = '';
						}

						if ($type == 'forums' AND ($col == 'id_parent' OR $col == 'id_forum'))
							$plat = true;

						// Operateur de comparaison
						if ($match[3]) {
							$op = $match[3];
							if ($op == '==') $op = ' REGEXP ';
						}
						else {
							$op = '=';
						}

						if ($col_table) $col_table .= '.';
						$req_where[] = "$col_table$col$op'$val'";
					}
	
					// Selection du classement
					else if (ereg('^par ([^}]*)$', $param, $match)) {
						if ($match[1] == 'hasard') {
							$req_select[] = "MOD($table.$id_objet * UNIX_TIMESTAMP(), 32767) & UNIX_TIMESTAMP() AS alea";
							$req_order = " ORDER BY alea";
						}
						else if ($match[1] == 'points'){
							$req_order= " ORDER BY points";
						}
						else {
							$col = $match[1];
							if ($col == 'date') $col = $col_date;
							$req_order = " ORDER BY $table.$col";
						}
					}
				}
			}

			//
			// Post-traitement separe par type
			//

			switch($type) {
			case 'articles':
				$post_dates = lire_meta("post_dates");
				if ($post_dates == 'non') $req_where[] = "$table.date<NOW()";
				$req_where[] = "$table.statut='publie'";
				break;

			case 'mots':
				// Si aucun lien avec un article, et si pas de demande de "tout" les mots-cles
				// alors selectionner uniquement les mots-cles attaches a un article publie
				if (!$tout AND !$flag_lien) {
					$req_from[] = 'spip_mots_articles AS lien';
					$req_from[] = 'spip_articles AS articles';
					$req_where[] = "lien.id_mot=$table.id_mot";
					$req_where[] = "lien.id_article=articles.id_article";
					$req_where[] = "articles.statut='publie'";
					$req_group = " GROUP BY $table.$id_objet";
				}
				break;

			case 'breves':
				$req_where[] = "$table.statut='publie'";
				break;

			case 'rubriques':
				if ($rubriques_publiques) $req_where[] = "$table.id_rubrique IN ($rubriques_publiques)";
				break;

			case 'forums':
				$forums_publics = lire_meta("forums_publics");
				// Par defaut, selectionner uniquement les forums sans pere
				if (!$plat) $req_where[] = "$table.id_parent=0";
				if ($forums_publics == 'non') {
					$req_where[] = "1=2";
				}
				$req_where[] = "$table.statut='publie'";
				break;

			case 'signatures':
				$req_from[] = 'spip_petitions AS petitions';
				$req_from[] = 'spip_articles AS articles';
				$req_where[] = "petitions.id_article=articles.id_article";
				$req_where[] = "petitions.id_article=$table.id_article";

				$req_where[] = "$table.statut='publie'";
				$req_group = " GROUP BY $table.$id_objet";
				break;
			
			case 'syndic_articles':
				$req_select[]='syndic.nom_site AS nom_site';
				$req_select[]='syndic.url_site AS url_site';
				$req_from[]='spip_syndic AS syndic';
				$req_where[] = "syndic.id_syndic=$table.id_syndic";
				break;

			case 'auteurs':
				// Si pas de lien avec un article, selectionner
				// uniquement les auteurs d'un article publie
				if (!$flag_lien) {
					$req_from[] = 'spip_auteurs_articles AS lien';
					$req_from[] = 'spip_articles AS articles';
					$req_where[] = "lien.id_auteur=$table.id_auteur";
					$req_where[] = "lien.id_article=articles.id_article";
					$req_where[] = "articles.statut='publie'";
					$req_group = " GROUP BY $table.$id_objet";
				}
				break;
			}
		}

		//
		// Construire la requete
		//
		if ($type == 'hierarchie')
			$requete = $req_limit;
		else if ($req_select) {
			$requete = 'SELECT '.join(',', $req_select).' FROM '.join(',', $req_from);
			if ($req_where) $requete .= ' WHERE '.join(' AND ', $req_where);
			$requete .= $req_group;
			$requete .= $req_order;
			if ($req_limit) $requete .= ' LIMIT '.$req_limit;
		}
		//echo $requete."<p>";
		$result->type_requete = $type;
		$result->requete = $requete;
		$result->doublons = $doublons;
		$result->separateur = $separateur;
	}


	//
	// Stocker le tout dans le resultat de la fonction
	//

	$result->id_boucle = $id_boucle;
	$result->commande = $commande;
	$result->avant = $debut;
	$result->cond_avant = parser_texte($cond_avant);
	$result->cond_apres = parser_texte($cond_fin);
	$result->cond_altern = parser_texte($cond_altern);
	$result->milieu = parser_texte($milieu);
	$result->apres = $fin;
	$result->partie = $partie;
	$result->total_parties = $total_parties;
	

	return $result;
}



function parser_champs($texte) {
	global $champs;
	global $champs_count;
	global $champs_valides;
	global $champs_traitement;

	$debut = '';
	while ($texte) {
		$r = ereg('(#([a-zA-Z_]+)(\*?))', $texte, $regs);
		if ($r) {
			unset($champ);
			$nom_champ = $regs[2];
			$flag_brut = $regs[3];
			$s = $regs[1];
			$p = strpos($texte, $s);
			if ($champs_valides[$nom_champ]) {
				$debut .= substr($texte, 0, $p);
				if ($debut) {
					$champ = new Texte;
					$champ->texte = $debut;
					$result[] = $champ;
				}
				$champ = new Champ;
				$champ->nom_champ = $nom_champ;
				if (!$flag_brut) $champ->fonctions = $champs_traitement[$nom_champ];
				$champs_count++;
				$champ->id_champ = $champs_count;
				$champs[$champs_count] = $champ;
				$result[] = $champ;
				$debut = '';
			}
			else {
				$debut .= substr($texte, 0, $p + strlen($s));
			}
			$texte = substr($texte, $p + strlen($s));
		}
		else {
			$champ = new Texte;
			$champ->texte = $debut.$texte;
			if ($champ->texte) $result[] = $champ;
			break;
		}
	}
	return $result;
}


function parser_champs_etendus($texte) {
	global $champs;
	global $champs_count;
	global $champs_valides;
	global $champs_traitement;

	$debut = '';
	while ($texte) {
		$r = ereg('(\[([^\[]*)\(#([a-zA-Z_]+)(\*?)([^]\)]*)\)([^]]*)\])', $texte, $regs);

		if ($r) {
			$cond_avant = $regs[2];
			$nom_champ = $regs[3];
			$flag_brut = $regs[4];
			$fonctions = $regs[5];
			$cond_apres = $regs[6];
			$s = $regs[1];
			$p = strpos($texte, $s);
			if ($champs_valides[$nom_champ]) {
				$debut .= substr($texte, 0, $p);
				if ($debut) {
					$c = parser_champs($debut);
					reset($c);
					while (list(, $val) = each($c)) $result[] = $val;
				}
				$champ = new Champ;
				$champ->nom_champ = $nom_champ;
				$champ->cond_avant = parser_champs($cond_avant);
				$champ->cond_apres = parser_champs($cond_apres);
				if (!$flag_brut) $champ->fonctions = $champs_traitement[$nom_champ];
				
				if ($fonctions) {
					$fonctions = explode('|', substr($fonctions, 1));
					reset($fonctions);
					while (list(, $f) = each($fonctions)) $champ->fonctions[] = $f;
				}
				$champs_count++;
				$champ->id_champ = $champs_count;
				$champs[$champs_count] = $champ;
				$result[] = $champ;
				$debut = '';
			}
			else {
				$debut .= substr($texte, 0, $p + strlen($s));
			}
			$texte = substr($texte, $p + strlen($s));
		}
		else {
			$c = parser_champs($debut.$texte);
			reset($c);
			while (list(, $val) = each($c)) $result[] = $val;
			break;
		}
	}
	return $result;	
}

function parser_texte($texte) {
	global $boucles;

	$i = 0;

	while ($texte) {
		$boucle = parser_boucle($texte);
		if ($boucle->type == 'texte') {
			if ($c = parser_champs_etendus($boucle->texte)) {
				reset($c);
				while (list(, $val) = each($c)) {
					$result[$i] = $val;
					$i++;
				}
			}
			$texte = '';
		}
		else {
			if ($c = parser_champs_etendus($boucle->avant)) {
				reset($c);
				while (list(, $val) = each($c)) {
					$result[$i] = $val;
					$i++;
				}
			}
			$texte = $boucle->apres;
			$boucle->avant = '';
			$boucle->apres = '';
			$result[$i] = $boucle;
			$i++;
			$id_boucle = $boucle->id_boucle;
			if (!$boucles[$id_boucle])
				$boucles[$id_boucle] = $boucle;
			else die ('<h2>BOUCLE'.$id_boucle.': double definition</h2>');
		}
	}

	return $result;
}


function parser($texte) {

	global $champs_valides;
	global $champs_traitement;

	global $rows_articles;
	global $rows_signatures;
	global $rows_syndication;
	global $rows_syndic_articles;
	global $rows_rubriques;
	global $rows_forums;
	global $rows_breves;
	global $rows_auteurs;
	global $rows_hierarchie;
	global $rows_mots;

	global $racine;

	//
	// Construire un tableau associatif des codes de champ utilisables
	//
	$c = array('NOM_SITE_SPIP', 'URL_SITE_SPIP',
		'ID_ARTICLE', 'ID_RUBRIQUE', 'ID_BREVE', 'ID_FORUM', 'ID_PARENT', 'ID_SECTEUR', 'ID_AUTEUR', 'ID_MOT',
		'ID_SYNDIC_ARTICLE', 'ID_SYNDIC', 'ID_SIGNATURE', 'MESSAGE',
		'TITRE', 'SURTITRE', 'SOUSTITRE', 'DESCRIPTIF', 'CHAPO', 'TEXTE', 'PS', 'NOTES', 'INTRODUCTION',
		'DATE', 'DATE_REDAC', 
		'LESAUTEURS', 'EMAIL', 'NOM_SITE', 'URL_SITE', 'NOM', 'IP', 'BIO', 'TYPE', 
		'FORMULAIRE_FORUM', 'PARAMETRES_FORUM', 'FORMULAIRE_RECHERCHE', 'FORMULAIRE_INSCRIPTION', 'FORMULAIRE_SIGNATURE',
		'LOGO_RUBRIQUE', 'LOGO_AUTEUR', 'LOGO_BREVE', 'LOGO_ARTICLE',  'LOGO_ARTICLE_RUBRIQUE', 'LOGO_ARTICLE_NORMAL', 'LOGO_ARTICLE_SURVOL',
		'URL_ARTICLE', 'URL_RUBRIQUE', 'URL_BREVE', 'URL_FORUM', 'URL_SYNDIC', 'URL_MOT',
		'VISITES', 'POINTS', 'COMPTEUR_BOUCLE', 'TOTAL_BOUCLE', 'PETITION'
	);
	reset($c);
	while (list(, $val) = each($c)) {
		$champs_valides[$val] = $val;
		$champs_traitement[$val][] = 'interdire_scripts';
	}

	//
	// Construire un tableau associatif des pre-traitements de champs
	//
	$c = array('NOM_SITE_SPIP', 'SURTITRE', 'TITRE', 'SOUSTITRE', 'NOM_SITE', 'NOM');
	reset($c);
	while (list(, $val) = each($c)) {
		unset($champs_traitement[$val]);
		$champs_traitement[$val][] = 'trim';
		$champs_traitement[$val][] = 'stripslashes';
		$champs_traitement[$val][] = 'typo';
	}
	$c = array('DESCRIPTIF', 'CHAPO', 'TEXTE', 'PS', 'BIO');
	reset($c);
	while (list(, $val) = each($c)) {
		unset($champs_traitement[$val]);
		$champs_traitement[$val][] = 'propre';
	}
	$c = array('DATE', 'DATE_REDAC');
	reset($c);
	while (list(, $val) = each($c)) {
		unset($champs_traitement[$val]);
		$champs_traitement[$val][] = 'vider_date';
	}


	//
	// Construire un tableau associatif des champs de chaque type
	// avec l'intitule de la colonne mysql correspondante
	//

	$rows_articles = array(
		'ID_ARTICLE' => 'id_article',
		'ID_RUBRIQUE' => 'id_rubrique',
		'ID_SECTEUR' => 'id_secteur',
		'SURTITRE' => 'surtitre',
		'TITRE' => 'titre',
		'SOUSTITRE' => 'soustitre',
		'DESCRIPTIF' => 'descriptif',
		'CHAPO' => 'chapo',
		'TEXTE' => 'texte',
		'PS' => 'ps',
		'DATE' => 'date',
		'DATE_REDAC' => 'date_redac',
		'VISITES' => 'visites',
		'POINTS' => 'points'
	);
	$rows_auteurs = array(
		'ID_AUTEUR' => 'id_auteur',
		'NOM' => 'nom',
		'BIO' => 'bio',
		'EMAIL' => 'email',
		'NOM_SITE' => 'nom_site',
		'URL_SITE' => 'url_site',
		'PGP' => 'pgp',
		'POINTS' => 'points'
	);
	$rows_breves = array(
		'ID_BREVE' => 'id_breve',
		'ID_RUBRIQUE' => 'id_rubrique',
		'DATE' => 'date_heure',
		'TITRE' => 'titre',
		'TEXTE' => 'texte',
		'NOM_SITE' => 'lien_titre',
		'URL_SITE' => 'lien_url',
		'POINTS' => 'points'
	);
	$rows_forums = array(
		'ID_FORUM' => 'id_forum',
		'ID_PARENT' => 'id_parent',
		'ID_BREVE' => 'id_breve',
		'ID_RUBRIQUE' => 'id_rubrique',
		'ID_ARTICLE' => 'id_article',
		'TITRE' => 'titre',
		'TEXTE' => 'texte',
		'DATE' => 'date_heure',
		'NOM' => 'auteur',
		'EMAIL' => 'email_auteur',
		'NOM_SITE' => 'nom_site',
		'URL_SITE' => 'url_site',
		'IP' => 'ip'
	);
	$rows_mots = array(
		'ID_MOT' => 'id_mot',
		'TYPE' => 'type',
		'TITRE' => 'titre',
		'DESCRIPTIF' => 'descriptif',
		'TEXTE' => 'texte',
		'POINTS' => 'points'
	);
	$rows_rubriques = array(
		'ID_RUBRIQUE' => 'id_rubrique',
		'ID_PARENT' => 'id_parent',
		'ID_SECTEUR' => 'id_secteur',
		'TITRE' => 'titre',
		'DESCRIPTIF' => 'descriptif',
		'TEXTE' => 'texte',
		'POINTS' => 'points'
	);
	$rows_hierarchie = $rows_rubriques;

	$rows_signatures = array(
		'ID_SIGNATURE' => 'id_signature',
		'ID_ARTICLE' => 'id_article',
		'DATE' => 'date_time',
		'NOM' => 'nom_email',
		'EMAIL' => 'ad_email',
		'NOM_SITE' => 'nom_site',
		'URL_SITE' => 'url_site',
		'MESSAGE' => 'message'
	);

	$rows_syndication = array(
		'ID_SYNDIC' => 'id_syndic',
		'ID_RUBRIQUE' => 'id_rubrique',
		'ID_SECTEUR' => 'id_secteur',
		'NOM_SITE' => 'nom_site',
		'URL_SITE' => 'url_site',
		'URL_SYNDIC' => 'url_syndic',
		'DESCRIPTIF' => 'descriptif'
	);
	$rows_syndic_articles = array(
		'ID_SYNDIC_ARTICLE' => 'id_syndic_article',
		'ID_SYNDIC' => 'id_syndic',
		'TITRE' => 'titre',
		'URL_ARTICLE' => 'url',
		'DATE' => 'date',
		'LESAUTEURS' => 'lesauteurs',
		'NOM_SITE' => 'nom_site',
		'URL_SITE' => 'url_site'
	);


	// Parser le texte et retourner le tableau racine

	$racine = parser_texte($texte);
}




//////////////////////////////////////////////////////////////////////////////
//
//              Execution des squelettes
//
//////////////////////////////////////////////////////////////////////////////


function executer_boucle($boucle, $id_parent_boucle, $contexte)
{
	global $boucles;
	global $rubriques_publiques;
	global $id_doublons;
	global $fichier_cache;
	global $requetes_cache;
	global $syn_rubriques;

	if ($contexte) {
		reset($contexte);
		while (list($key, $val) = each($contexte)) {
			$$key = $val;
		}
	}

	if ($recursion = $boucles[$id_parent_boucle]->recursion) {
		$id_boucle = $boucle->id_boucle."($recursion)";
		$boucle->id_boucle = $id_boucle;
		$boucle->code = '';
		$boucle->id_row = '';
		$boucle->recursion = $recursion;
		$boucles[$id_boucle] = $boucle;
	}

	$texte = '';
	$type_boucle = $boucle->type_requete;
	$id_boucle = $boucle->id_boucle;
	$boucles[$id_boucle]->id_parent = $id_parent_boucle;
	$doublons = $boucle->doublons;
	$partie = $boucle->partie;
	$total_parties = $boucle->total_parties;
	

	if ($type_boucle == 'boucle') {
		$boucles[$id_boucle]->recursion++;
		return executer_liste(array($boucles[$boucle->requete]), $id_boucle, $contexte);
	}

	else if ($type_boucle == 'hierarchie') {
		if ($id_article) $hierarchie = parent($id_rubrique);
		else $hierarchie = parent($id_parent);
		if ($hierarchie) $hierarchie = explode('-', substr($hierarchie, 1));

		$deb_class = 0;
		if (ereg('([0-9]+),([0-9]*)', $boucle->requete, $match)){
			$deb_class = $match[1];
			if ($match[2]) $fin_class = $match[2] + $deb_class;
		}
		if (!$fin_class) $fin_class = sizeof($hierarchie);

		for ($i = $deb_class; $i < $fin_class; $i++) {
			$query = 'SELECT * FROM spip_rubriques WHERE id_rubrique='.$hierarchie[$i];
			if ($doublons == 'oui') $query .= " AND id_rubrique NOT IN ($id_doublons[rubriques])";
			$result = mysql_query($query);
			if ($result) if ($row = mysql_fetch_array($result)) {

				$boucles[$id_boucle]->row = $row;
				if ($texte) $texte .= $boucle->separateur;
	
				$contexte['id_rubrique'] = $row[0];
				$contexte['id_parent'] = $row[1];
				$contexte['id_secteur'] = $row[5];
	
				if ($doublons == 'oui') {
					$id_doublons['rubriques'] .= ','.$row[0];
				}

				$texte .= executer_liste($boucle->milieu, $id_boucle, $contexte);
			}
		} // for
		return $texte;

	}
	

	if ($type_boucle == 'forums') {
		
		if ($id_article>0){
			$query_acc = "SELECT * FROM spip_articles WHERE id_article='$id_article'";
			$result_acc = mysql_query($query_acc);

			if ($row = mysql_fetch_array($result_acc)) {
				$accepter_forum=$row["accepter_forum"];
			}
			if ($accepter_forum=="non"){
				$boucle->requete = "SELECT * FROM spip_forum WHERE 1=2";
			}
		}
		
		
		if (!$id_rubrique AND !$id_article AND !$id_breve)
			$my_id_forum = $id_forum;
		else
			$my_id_forum = 0;
		if(!$id_article) $id_article=0;
		if(!$id_rubrique) $id_rubrique=0;
		if(!$id_breve) $id_breve=0;
		$valeurs = "$id_article, $id_rubrique, $id_breve, $my_id_forum, '$fichier_cache'";
		
		if (!$requetes_cache[$valeurs]) {
			$query = "INSERT spip_forum_cache (id_article, id_rubrique, id_breve, id_forum, fichier) VALUES ($valeurs)";
			mysql_query($query);
			$requetes_cache[$valeurs] = 1;
		}
	}

	if ($type_boucle == 'syndic_articles'){
		if ($id_rubrique AND !ereg(",id_rubrique,",$syn_rubriques)){
			$syn_rubrique.=",$id_rubrique,";
			$query_syn="SELECT url_syndic, id_syndic FROM spip_syndic WHERE id_rubrique=$id_rubrique";
			$result_syn=mysql_query($query_syn);
			 while($row=mysql_fetch_array($result_syn)){
				$now_url_site=$row['url_syndic'];
				$now_id_syndic=$row['id_syndic'];
				syndic_a_jour($now_url_site,$now_id_syndic);
			}
		}
	}

	$query = $boucle->requete;
	eval("\$query = \"$query\";");
	
	//echo "<LI>$query";
	
	$result = mysql_query($query);
	if (!$result) {
		$texte .= "<blink>BOUCLE$id_boucle</blink> <small><i>$query</i></small> <blink>BOUCLE$id_boucle</blink>"; // debugger les squelettes
		return $texte;
	}

	
	$total_boucle = mysql_num_rows($result);
	$boucles[$id_boucle]->num_rows = $total_boucle;
	
	if ($partie AND $total_parties) {
		$debut_boucle = floor(($total_boucle * ($partie - 1) + $total_parties - 1) / $total_parties) + 1;
		$fin_boucle = floor(($total_boucle * ($partie) + $total_parties - 1) / $total_parties);
//		if ($partie == $total_parties) $fin_boucle = $total_boucle; // inutile ?
	}
	else {
		$debut_boucle = 1;
		$fin_boucle = $total_boucle;
	}
	
	$boucles[$id_boucle]->total_boucle = $fin_boucle - $debut_boucle + 1;
	$boucles[$id_boucle]->compteur_boucle = 0;
	$compteur_boucle = 0;
	
	while ($row = mysql_fetch_array($result)) {
		$compteur_boucle++;

		if ($compteur_boucle >= $debut_boucle AND $compteur_boucle <= $fin_boucle) {
	
			$boucles[$id_boucle]->compteur_boucle++;
			$boucles[$id_boucle]->row = $row;

			if ($texte) $texte .= $boucle->separateur;

			switch($type_boucle) {

			/////////////////////
			// Articles
			//
			case 'articles':
				$contexte['id_article'] = $row['id_article'];
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$contexte['id_secteur'] = $row['id_secteur'];
				$contexte['accepter_forum'] = $row['accepter_forum'];
				if ($doublons == 'oui') $id_doublons['articles'] .= ','.$row['id_article'];
				break;

			/////////////////////
			// Breves
			//
			case 'breves':
				$contexte['id_breve'] = $row['id_breve'];
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$contexte['id_secteur'] = $row['id_secteur'];
				if ($doublons == 'oui') $id_doublons['breves'] .= ','.$row['id_breve'];
				break;

			/////////////////////
			// Syndication
			//
			case 'syndication':
				$contexte['id_syndic'] = $row['id_syndic'];
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$contexte['id_secteur'] = $row['id_secteur'];
				
				syndic_a_jour($row['url_syndic'], $row['id_syndic']);
				break;


			/////////////////////
			// Rubriques
			//
			case 'rubriques':
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$contexte['id_parent'] = $row['id_parent'];
				$contexte['id_secteur'] = $row['id_secteur'];
				if ($doublons == 'oui') $id_doublons['rubriques'] .= ','.$row['id_rubrique'];

				$syn_rubrique .= ",".$row['id_rubrique'].",";
				break;

			/////////////////////
			// Forums
			//
			case 'forums':
				$contexte['id_forum'] = $row['id_forum'];
				$contexte['id_rubrique'] = $row['id_rubrique'];
				$contexte['id_article'] = $row['id_article'];
				$contexte['id_breve'] = $row['id_breve'];
				if ($doublons == 'oui') $id_doublons['forums'] .= ','.$row['id_forum'];
				break;

			/////////////////////
			// Auteurs
			//
			case 'auteurs':
				$contexte['id_auteur'] = $row['id_auteur'];
				if ($doublons == 'oui') $id_doublons['auteurs'] .= ','.$row['id_auteur'];
				break;

			/////////////////////
			// Signatures
			//
			case 'signatures':
				$contexte['id_signature'] = $row['id_signature'];
				break;

			/////////////////////
			// Mots
			//
			case 'mots':
				$contexte['id_mot'] = $row['id_mot'];
				$contexte['type'] = $row['type'];
				if ($doublons == 'oui') $id_doublons['mots'] .= ','.$row['id_mot'];
				break;
			}

			$texte .= executer_liste($boucle->milieu, $id_boucle, $contexte);
		}

	}

	mysql_free_result($result);
	return $texte;
}


function executer_champ($objet, $id_boucle, $contexte)
{
	global $les_notes;
	global $boucles;
	global $champs;

	$id_champ = $objet->id_champ;

	if ($contexte) {
		reset($contexte);
		while (list($key, $val) = each($contexte)) {
			$$key = $val;
		}
	}

	$idb = $id_boucle;
	$id_row = $champs[$id_champ]->id_row;
	if (!$id_row) {
		//
		// Si pas de valeur cachee de $id_row, calculer en
		// prenant la boucle la plus proche qui autorise le
		// champ demande
		//
		while ($idb != '') {
			// $rows_articles, etc. : tables pregenerees contenant les correspondances
			// (nom du champ -> numero de colonne mysql) en fonction du type de requete
			$id_row = $GLOBALS['rows_'.$boucles[$idb]->type_requete][$objet->nom_champ];
			if ($id_row) break;
			$idb = $boucles[$idb]->id_parent;
		}
		// valeur indiquant les cas particuliers, a traiter separement (voir plus loin)
		if (!$id_row)
			$id_row = '!';
		else
			$champs[$id_champ]->id_boucle = $idb;
		$champs[$id_champ]->id_row = $id_row;
	}

	//
	// Si cas general (le plus simple), generation et sauvegarde du code php effectuant le calcul du champ
	//
	if ($id_row != '!') {
		$fonctions = $objet->fonctions;
		
		$code = "\$boucles['$idb']->row[$id_row]";
		if ($fonctions) {
			while (list(, $fonc) = each($fonctions))
				$code = "$fonc($code)";
		}
		$code = '$milieu='.$code.';';
		$champs[$id_champ]->code = $code;
		// execution du code
		eval($code);
		return $milieu;
	}


	//
	// Ici traitement des cas particuliers
	//

	$milieu = '<blink>#'.$objet->nom_champ.'</blink>'; // pour debugger les squelettes
	$fonctions = $objet->fonctions;
	switch($objet->nom_champ) {

	case 'LOGO_RUBRIQUE':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_rubrique($id_rubrique);

		$image = image_rubrique($id_rubrique);
		$rubon = $image[0];
		$ruboff = $image[1];

		if ($nomdufichier) $milieu = $rubon;
		else $milieu = affiche_logos($rubon, $ruboff, $lien, $align);
		break;

	case 'LOGO_AUTEUR':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
			
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#ID_AUTEUR', $id_auteur, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
					if (ereg('#EMAIL',$lien)){
						$query_auteur="SELECT email FROM spip_auteurs WHERE id_auteur='$id_auteur'";
						$result_auteur=mysql_query($query_auteur);
						while($row=mysql_fetch_array($result_auteur)){
							$email=$row['email'];
							$lien = ereg_replace('#EMAIL', $email, $lien);
						}
					}
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_auteur($id_auteur);
		$arton = $image[0];
		$artoff = $image[1];

		if ($nomdufichier) $milieu = $arton;
		else $milieu = affiche_logos($arton, $artoff, $lien, $align);
		break;


	case 'LOGO_BREVE':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
			
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_breve($id_breve);
		$arton = $image[0];
		$artoff = $image[1];

		if ($nomdufichier) $milieu = $arton;
		else $milieu = affiche_logos($arton, $artoff, $lien, $align);
		break;

	case 'LOGO_ARTICLE':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_article($id_article);
		$arton = $image[0];
		$artoff = $image[1];

		if ($nomdufichier) $milieu = $arton;
		else $milieu = affiche_logos($arton, $artoff, $lien, $align);
		break;

	case 'LOGO_ARTICLE_NORMAL':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_article($id_article);
		$arton = $image[0];

		if ($nomdufichier) $milieu = $arton;
		else $milieu = affiche_logos($arton, '', $lien, $align);
		break;

	case 'LOGO_ARTICLE_SURVOL':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_article($id_article);
		$artoff = $image[1];

		if ($nomdufichier) $milieu = $artoff;
		else $milieu = affiche_logos($artoff, '', $lien, $align);
		break;

	case 'LOGO_ARTICLE_RUBRIQUE':
		if ($fonctions) {
			while (list(, $nom) = each($fonctions)) {
				if (ereg('^(left|right|center|top|bottom)$', $nom))
					$align = $nom;
				else if ($nom == 'lien')
					$lien_auto = true;
				else if ($nom == 'fichier')
					$nomdufichier = true;
				else {
					$lien = ereg_replace('#ID_RUBRIQUE', $id_rubrique, $nom);
					$lien = ereg_replace('#ID_ARTICLE', $id_article, $lien);
					$lien = ereg_replace('#ID_SECTEUR', $id_secteur, $lien);
					$lien = ereg_replace('#ID_BREVE', $id_breve, $lien);
					$lien = ereg_replace('#ID_FORUM', $id_forum, $lien);
					$lien = ereg_replace('#URL_ARTICLE', generer_url_article($id_article), $lien);
					$lien = ereg_replace('#URL_RUBRIQUE', generer_url_rubrique($id_rubrique), $lien);
					$lien = ereg_replace('#URL_SECTEUR', generer_url_rubrique($id_secteur), $lien);
					$lien = ereg_replace('#URL_BREVE', generer_url_breve($id_breve), $lien);
					$lien = ereg_replace('#URL_FORUM', generer_url_forum($id_forum), $lien);
				}
			}
			$fonctions = '';
		}
		if ($lien_auto && !$lien) $lien = generer_url_article($id_article);

		$image = image_article($id_article);
		$arton = $image[0];
		$artoff = $image[1];
		
		if (strlen($arton) < 5) {
			$image = image_rubrique($id_rubrique);
			$arton = $image[0];
			$artoff = $image[1];
		}

		if ($nomdufichier) $milieu = $arton;
		else $milieu = affiche_logos($arton, $artoff, $lien, $align);
		break;

	case 'LESAUTEURS':
		if ($boucles[$id_boucle]->type_requete == 'articles') {
			$query_auteurs = "SELECT spip_auteurs.* FROM spip_auteurs, spip_auteurs_articles AS lien WHERE lien.id_article=$id_article AND spip_auteurs.id_auteur=lien.id_auteur";
			$result_auteurs = mysql_query($query_auteurs);
			$auteurs = '';
			while($row = mysql_fetch_array($result_auteurs)) {
				$nom_auteur=propre($row[1]);
				$email_auteur=$row[3];
				if ($email_auteur) {
					$auteurs[] = "<A HREF='mailto:$email_auteur'>$nom_auteur</A>";
				}
				else {
					$auteurs[] = "$nom_auteur";
				}
			}
			if ($auteurs) $milieu = join($auteurs,", ");
			else $milieu = '';
		}
		break;

	case 'FORMULAIRE_RECHERCHE':
		if ($fonctions) {
			list(, $lien) = each($fonctions);
			$fonctions = '';
		}
		if (lire_meta('activer_moteur') != 'oui') {
			$milieu = '';
		}
		else {
			if (!$lien) $lien = 'recherche.php3';
			$milieu = "\n<A NAME='formulaire_recherche'>";
			$milieu .= "\n<FORM ACTION='$lien' METHOD='post'>";
			$milieu .= "\n<INPUT TYPE='text' NAME='recherche' VALUE='Rechercher' SIZE=20 CLASS='formrecherche'>";
			$milieu .= "\n</FORM>";
		}
		break;

	case 'INTRODUCTION':
		switch ($boucles[$id_boucle]->type_requete) {
		case 'articles':
			$code = "PtoBR(propre(couper(\$boucles['$id_boucle']->row['chapo'].\"\\n\\n\\n\".\$boucles['$id_boucle']->row['texte'], 500)))";
			break;
		case 'breves':
			$code = "PtoBR(propre(couper(\$boucles['$id_boucle']->row['texte'], 300)))";
			break;
		case 'forums':
			$code = "PtoBR(propre(couper(\$boucles['$id_boucle']->row['texte'], 600)))";
			break;
		}
		break;

	case 'URL_SITE_SPIP':
		$code = "lire_meta('adresse_site')";
		break;

	case 'NOM_SITE_SPIP':
		$code = "propre(lire_meta('nom_site'))";
		break;

	case 'URL_ARTICLE':
		if ($id_article) $code = "generer_url_article(\$contexte['id_article'])";
		break;

	case 'URL_RUBRIQUE':
		if ($id_rubrique) $code = "generer_url_rubrique(\$contexte['id_rubrique'])";
		break;

	case 'URL_BREVE':
		if ($id_breve) $code = "generer_url_breve(\$contexte['id_breve'])";
		break;

	case 'URL_FORUM':
		if ($id_forum) $code = "generer_url_forum(\$contexte['id_forum'])";
		break;

	case 'URL_MOT':
		if ($id_mot) $code = "generer_url_mot(\$contexte['id_mot'])";
		break;

	case 'NOTES':
		$code = '$les_notes';
		break;

	case 'COMPTEUR_BOUCLE':
		$code = "\$boucles['$id_boucle']->compteur_boucle";
		break;

	case 'TOTAL_BOUCLE':
		if ($id_boucle_interieure) $i = $id_boucle_interieure;
		else $i = $id_boucle;
		$code = "\$boucles['$i']->total_boucle";
		break;

	case 'FORMULAIRE_INSCRIPTION':
		global $REQUEST_URI;
		
		$lien = substr($REQUEST_URI, strrpos($REQUEST_URI, "/") + 1);
		if (strpos($lien,"?")>0)
			$lapage=substr($lien, 0, strpos($lien,"?"));
		else
			$lapage=$lien;
		$lesvars=substr($lien, strpos($lien,"?") + 1, strlen($lien));

		$retour="<P><B><"."? reponse_inscription(); ?"."></B>";

		$retour.= "\n<FORM ACTION='$lapage' METHOD='get'>\n";
		$lesvars=explode("&",$lesvars);

		for($i=0;$i<count($lesvars);$i++){
			$var_loc=explode("=",$lesvars[$i]);
			if ($var_loc[0] != "Submit")
				$retour.= "<INPUT TYPE='Hidden' NAME='$var_loc[0]' VALUE='$var_loc[1]'>\n";
		}
	
		$retour.= "<P><B>Votre nom ou pseudo</B><BR>(your name or pseudo)<BR>";
		$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='nom_inscription' VALUE='' SIZE='30'>";
		$retour.= "<P><B>Votre adresse email</B><BR>(your email adress)<BR>";
		$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='mail_inscription' VALUE='vous@fournisseur.com' SIZE='30'>";
		$retour.= "<DIV ALIGN='right'><INPUT TYPE='submit' NAME='Valider' VALUE='Valider'>";
	
		$retour.= "</FORM>";
		$milieu=$retour;
		break;

	case 'FORMULAIRE_SIGNATURE':
		global $REQUEST_URI;
		$lien = substr($REQUEST_URI, strrpos($REQUEST_URI, "/") + 1);

		$query_petition = "SELECT * FROM spip_petitions WHERE id_article=$id_article";
 		$result_petition = mysql_query($query_petition);

		if ($row = mysql_fetch_array($result_petition)) {
			$id_article=$row[0];
			$email_unique=$row[1];
			$site_obli=$row[2];
			$site_unique=$row[3];
			$message_petition=$row[4];
			$texte_petition=$row[5];

			$lapage=substr($lien, 0, strpos($lien,"?"));
			$lesvars=substr($lien, strpos($lien,"?") + 1, strlen($lien));
			
			$retour="<B><"."? reponse_signature(); ?"."></B>";
			$retour.= "\n<FORM ACTION='$lapage' METHOD='get'>\n";
			$lesvars=explode("&",$lesvars);
	
			for($i=0;$i<count($lesvars);$i++){
				$var_loc=explode("=",$lesvars[$i]);
				if ($var_loc[0] != "Submit")
					$retour.= "<INPUT TYPE='Hidden' NAME='$var_loc[0]' VALUE='$var_loc[1]'>\n";
			}
			
			$retour.= propre($texte_petition);
			$retour.= "<INPUT TYPE='Hidden' NAME='id_article' VALUE='$id_article'>";
			
			$retour.= "<P><B>Votre nom ou pseudo</B><BR>(your name or pseudo)<BR>";
			$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='nom_email' VALUE='' SIZE='30'>";
		
			$retour.= "<P><B>Votre adresse email</B><BR>(your email adress)<BR>";
			$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='ad_email' VALUE='vous@fournisseur.com' SIZE='30'>";

			if ($site_obli == "oui") {
				$retour.= "<P><B>Nom de votre site</B><BR>(name of your website)<BR>";
				$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='nom_site' VALUE='' SIZE='30'>";
			
				$retour.= "<P><B>Adresse de votre site</B><BR>(URL of your website)<BR>";
				$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='url_site' VALUE='http://' SIZE='30'>";
			}
			else {
				$retour.= "<P><B>Si vous avez un site Web, vous pouvez l'indiquer ci-dessous</B> (<I>if you own a website...</I>)<BR>";
			
				$retour.= "<B>Nom de votre site</B><BR>(name of your website)<BR>";
				$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='nom_site' VALUE='' SIZE='30'>";
			
				$retour.= "<BR><B>Adresse de votre site</B><BR>(URL of your website)<BR>";
				$retour.= "<INPUT TYPE='text' CLASS='forml' NAME='url_site' VALUE='http://' SIZE='30'>";
			}
			
			if ($message_petition == "oui") {
				$retour.= "<P><B>Un message, un commentaire&nbsp;?</B><BR>(a message, any comment?)<BR>";
				$retour.= "<TEXTAREA NAME='message' ROWS='3' CLASS='forml' COLS='30'>";
				$retour.= "</TEXTAREA><P>\n";
			}
			else {
				$retour.= "<INPUT TYPE='Hidden' NAME='message' VALUE=''>";
			}
			$retour.= "<DIV ALIGN='right'><INPUT TYPE='submit' NAME='Valider' VALUE='Valider'>";
			$retour.= "</FORM>";
		}
		$milieu = $retour;
		break;

	case 'PETITION':
		$pet_query = "SELECT id_article FROM spip_petitions WHERE id_article=$id_article";
		$pet_result = mysql_query($pet_query);
		if (mysql_num_rows($pet_result) > 0) $milieu = " ";
		else $milieu = "";
		break;

	case 'FORMULAIRE_FORUM':
		switch ($boucles[$id_boucle]->type_requete) {
		case 'articles':
			$titre = $boucles[$id_boucle]->row['titre'];
			$milieu = retour_forum(0, 0, $id_article, 0, '> '.$titre);
			break;

		case 'breves':
			$titre = $boucles[$id_boucle]->row['titre'];
			$milieu = retour_forum(0, 0, 0, $id_breve, '> '.$titre);
			break;

		case 'forums':
			$titre = $boucles[$id_boucle]->row['titre'];
			$milieu = retour_forum($id_rubrique, $id_forum, $id_article, $id_breve, '> '.$titre);
			break;

		case 'rubriques':
			$titre = $boucles[$id_boucle]->row['titre'];
			$milieu = retour_forum($id_rubrique, 0, 0, 0, '> '.$titre);
			break;

		default:
			$milieu = retour_forum($id_rubrique, $id_forum, $id_article, $id_breve, '> '.$titre);
			break;
		}
		break;

	case 'PARAMETRES_FORUM':
		global $REQUEST_URI, $HTTP_GET_VARS;
		$forums_publics = lire_meta("forums_publics");
		if ($forums_publics != "non" AND $contexte['accepter_forum']!="non") {
			$lien = substr($REQUEST_URI, strrpos($REQUEST_URI, '/') + 1);
			$retour = $HTTP_GET_VARS['retour'];
			if ($retour)
				$retour = $retour;
			else 
				$retour = rawurlencode($lien);

			switch ($boucles[$id_boucle]->type_requete) {
			case 'articles':
				$titre = $boucles[$id_boucle]->row['titre'];
				$milieu = "id_article=$id_article";
				break;

			case 'breves':
				$titre = $boucles[$id_boucle]->row['titre'];
				$milieu = "id_breve=$id_breve";
				break;

			case 'forums':
				$titre = $boucles[$id_boucle]->row['titre'];
				$milieu = "id_article=$id_article&id_breve=$id_breve&id_rubrique=$id_rubrique&id_forum=$id_forum";
				break;

			case 'rubriques':
				$titre = $boucles[$id_boucle]->row['titre'];
				$milieu = "id_rubrique=$id_rubrique";
				break;
			
			default:
				$titre = 'Titre';
				$milieu = "id_article=$id_article&id_breve=$id_breve&id_rubrique=$id_rubrique&id_forum=$id_forum";
				break;
			}
			if ($HTTP_GET_VARS['titre']){
				$titre = "> ".rawurldecode($HTTP_GET_VARS['titre']);
			}
			$milieu .= "&titre=".rawurlencode(substr(stripslashes($titre), 0, 50))."&retour=$retour";
		}else{
			$milieu="";
		}
		break;

	} // switch

	if ($code) {
		if ($fonctions) {
			while (list(, $fonc) = each($fonctions))
				$code = "$fonc($code)";
		}
		$code = '$milieu='.$code.';';
		$champs[$id_champ]->code = $code;
		eval($code);
	}
	else {
		if ($fonctions)
			while (list(, $fonc) = each($fonctions)) $milieu = $fonc($milieu);
	}

	return $milieu;
}


function executer_liste($tableau, $id_boucle, $contexte)
{
	global $boucles;
	global $champs;

	$texte = '';
	if (!$tableau) return $texte;

	reset($tableau);
	while (list(, $objet) = each($tableau)) {
		$milieu = '';
		switch($objet->type) {

		/////////////////////
		// Texte
		//
		case 'texte':
			$texte .= $objet->texte;
			break;


		/////////////////////
		// Boucle
		//
		case 'boucle':
			$milieu = executer_boucle($objet, $id_boucle, $contexte);
			$contexte['id_boucle_interieure'] = $objet->id_boucle;     // special #TOTAL_BOUCLE
			if ($milieu) {
				if ($s = $objet->cond_avant) {
					$texte .= executer_liste($s, $id_boucle, $contexte);
				}
				$texte .= $milieu;
				if ($s = $objet->cond_apres) {
					$texte .= executer_liste($s, $id_boucle, $contexte);
				}
			}
			else {
				if ($s = $objet->cond_altern) {
					$texte .= executer_liste($s, $id_boucle, $contexte);
				}
			}
			$contexte['id_boucle_interieure'] = '';
			break;


		/////////////////////
		// Champ
		//
		case 'champ':
			$id_champ_original = $objet->id_champ;
			$id_champ = "$id_champ_original $id_boucle";
			if (!$champs[$id_champ]) {
				$champs[$id_champ] = $champs[$id_champ_original];
				$champs[$id_champ]->id_champ = $id_champ;
			}

			//
			// Cas general : executer directement le code cache
			//
			if ($code = $champs[$id_champ]->code) {
				eval($code);
			}
			else {
				$milieu = executer_champ($champs[$id_champ], $id_boucle, $contexte);
			}

			if ($milieu) {
				if ($s = $objet->cond_avant) {
					$texte .= executer_liste($s, $id_boucle, $contexte);
				}
				$texte .= $milieu;
				if ($s = $objet->cond_apres) {
					$texte .= executer_liste($s, $id_boucle, $contexte);
				}
			}
			break;

		} // switch

	} // while

	return $texte;
}



//////////////////////////////////////////////////////////////////////////////
//
//              Calcul de la page
//
//////////////////////////////////////////////////////////////////////////////


function calculer_page() {

	global $id_doublons;
	global $fichier_requete, $fond;
	global $contexte, $racine;
	global $id_rubrique_fond;

	$contexte = '';
	$id_doublons['articles'] = '0';
	$id_doublons['rubriques'] = '0';
	$id_doublons['breves'] = '0';
	$id_doublons['auteurs'] = '0';
	$id_doublons['forums'] = '0';
	$id_doublons['mots'] = '0';

	calculer_rubriques_publiques();

	// recherche de rubriques
	if (!$id_parent) $id_parent = 0;
	if ($id_rubrique_fond > 0) $fond = page_parent($fond, $id_rubrique_fond);

	$contexte_defaut = array('id_parent', 'id_rubrique', 'id_article', 'id_auteur',
		'id_breve', 'id_forum', 'id_secteur', 'id_syndic', 'id_mot');
	reset($contexte_defaut);
	while (list(, $val) = each($contexte_defaut)) {
		if ($GLOBALS[$val]) {
			$contexte[$val] = (int) $GLOBALS[$val];
		}
	}

	recuperer_parametres_url($fond, $fichier_requete);

	$html = join(file("$fond.html"), "");
	parser($html);

	// Special stats et boutons admin
	reset($contexte_defaut);
	while (list($key, $val) = each($contexte_defaut)) {
		if ($contexte[$val]) {
			$GLOBALS[$val] = $contexte[$val];
			$retour .= '<? $'.$val.' = '.$contexte[$val]."; ?>\n";
		}
	}

	$retour .= executer_liste($racine, '', $contexte);

	return $retour;
}

?>
