<?

if ($spip_version > 0) return;

//
// Infos de version PHP
//

$php_version = explode('.', phpversion());
$php_version_maj = (int) $php_version[0];
$php_version_med = (int) $php_version[1];
if (ereg('([0-9]+)', $php_version[2], $match)) $php_version_min = (int) $match[1];

$flag_function_exists = ($php_version_maj > 3 OR $php_version_min >= 7);
$flag_ignore_user_abort = ($php_version_maj > 3 OR $php_version_min >= 7);
$flag_levenshtein = ($php_version_maj >= 4);
$flag_mt_rand = ($php_version_maj > 3 OR $php_version_min >= 6);
$flag_str_replace = ($php_version_maj > 3 OR $php_version_min >= 8);
$flag_strpos_3 = (@strpos('baba', 'a', 2) == 3);

if ($flag_function_exists) {
	$gz_exists = function_exists("gzopen");
	$flag_preg_replace = function_exists("preg_replace");
}
else {
	$gz_exists = false;
	$flag_preg_replace = false;
}



//
// Version courante de SPIP
// Stockee sous forme de nombre decimal afin de faciliter les comparaisons
// (utilise pour les modifs de la base de donnees)
//

$spip_version = 1.05;



function analyser_version($version) {
	ereg('([0-9]*)((\.([0-9]+))(\.([0-9]+))?)?([a-zA-Z]+)?', $version, $regs);
	$result[0] = (int) $regs[1];
	$result[1] = (int) $regs[4];
	$result[2] = (int) $regs[6];
	$result[3] = $regs[7];
	return $result;
}

// Retourne vrai si la version actuelle est
// anterieure a celle passee en parametre

function version_anterieure($version) {
	global $spip_version;
	$sv = analyser_version($spip_version);
	$v = analyser_version($version);
	if ($sv[0] != $v[0]) return ($sv[0] < $v[0]);
	if ($sv[1] != $v[1]) return ($sv[1] < $v[1]);
	if ($sv[2] != $v[2]) return ($sv[2] < $v[2]);
	return ($sv[3] < $v[3]);
}

?>