<?


//
// Trouver une locale qui 'marche' : si 'fr' et 'fr_FR' ne suffisent pas,
// il suffit d'ajouter des lignes...
//

setlocale('LC_CTYPE', 'fr') ||
setlocale('LC_CTYPE', 'FR_fr') ||
setlocale('LC_CTYPE', 'fr_FR');


function vider_date($letexte) {
	if (ereg("^0000-00-00", $letexte)) return '';
	return $letexte;
}

function affdate_base($numdate, $vue, $lang = 'fr') {
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	if (substr($jour, 0, 1) == '0') $jour = substr($jour, 1);
	if (($lang ==  "") || ($lang == "fr")) {
		if ($jour == '1') $jour = '1er';
		$tab_mois = array(0,
			'janvier', 'f&eacute;vrier', 'mars', 'avril', 'mai', 'juin',
			'juillet', 'ao&ucirc;t', 'septembre', 'octobre', 'novembre', 'd&eacute;cembre');
		$avjc = ' av. J.C.';
	}
	else {
		switch($jour) {
		case '1':
			$jour = '1st';
			break;
		case '2':
			$jour = '2nd';
			break;
		case '3':
			$jour = '3rd';
			break;
		case '21':
			$jour = '21st';
			break;
		case '22':
			$jour = '22nd';
			break;
		case '23':
			$jour = '23rd';
			break;
		case '31':
			$jour = '31st';
			break;
		}
		$tab_mois = array(0,
			'january', 'february', 'march', 'april', 'may', 'june',
			'july', 'august', 'september', 'october', 'november', 'december');
		$avjc = ' B.C.';
	}

	if ($jour) $jour .= ' ';
	$mois = $tab_mois[(int) $mois];
	if ($annee < 0) {
		$annee = -$annee.$avjc;
		$avjc = true;
	}
	else $avjc = false;

	switch ($vue) {
	case 'court':
		if ($avjc) return $annee;
		$a = date('Y');
		if ($annee < ($a - 100) OR $annee > ($a + 100)) return $annee;
		if ($annee != $a) return ucfirst($mois)." $annee";
		return $jour.$mois;

	case 'entier':
		if ($avjc) return $annee;
		return "$jour$mois $annee";

	case 'mois':
		//if ($avjc) return $annee;
		return "$mois";
	

	case 'mois_annee':
		if ($avjc) return $annee;
		return "$mois $annee";
	}

	return '<blink>format non d&eacute;fini</blink>';
}



function nom_jour($numdate, $lang = 'fr'){
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	

	
	$nom=mktime(1,1,1,$mois,$jour,$annee);
	$nom=date("D",$nom);

	if (($lang ==  "") || ($lang == "fr")) {
		switch($nom){
			case 'Sun': $nom='dimanche'; break;		
			case 'Mon': $nom='lundi'; break;		
			case 'Tue': $nom='mardi'; break;		
			case 'Wed': $nom='mercredi'; break;		
			case 'Thu': $nom='jeudi'; break;		
			case 'Fri': $nom='vendredi'; break;		
			case 'Sat': $nom='samedi'; break;		
		}
	}else{
		switch($nom){
			case 'Sun': $nom='Sunday'; break;		
			case 'Mon': $nom='Monday'; break;		
			case 'Tue': $nom='Tuesday'; break;		
			case 'Wed': $nom='Wednesday'; break;		
			case 'Thu': $nom='Thursday'; break;		
			case 'Fri': $nom='Friday'; break;		
			case 'Sat': $nom='Saturday'; break;		
		}
	}
	
	return $nom;
}


function jour($numdate, $lang = 'fr') {
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	
	return $jour;
}


function mois($numdate, $lang = 'fr') {
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	
	return $mois;
}


function annee($numdate, $lang = 'fr') {
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	
	return $annee;
}




function affdate($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'entier', $lang);
}


function affdate_court($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'court', $lang);
}


function affdate_mois_annee($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'mois_annee', $lang);
}


function nom_mois($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'mois', $lang);
}


function majuscules($texte) {
	$suite = htmlentities($texte);
	$suite = ereg_replace('&amp;', '&', $suite);
	$suite = ereg_replace('&lt;', '<', $suite);
	$suite = ereg_replace('&gt;', '>', $suite);
	$texte = '';
	while (ereg('^([^&]*)&([A-Za-z])([a-zA-Z]*);(.*)$', $suite, $regs)) {
		$texte .= strtoupper($regs[1]);
		$suite = $regs[4];
		$carspe = $regs[2];
		$accent = $regs[3];
		if (ereg('^(acute|grave|circ|uml|cedil|slash|caron|ring|tilde|elig)$', $accent))
			$carspe = strtoupper($carspe); 
		if ($accent == 'elig') $accent = 'Elig';
		$texte .= '&'.$carspe.$accent.';';
	}
	$texte .= strtoupper($suite);
	return $texte;
}

function justifier($letexte) {
	$letexte = eregi_replace("<P>","\n<P align='justify'>",$letexte);
	return "<P align='justify'>".$letexte;
}

function textebrut($letexte) {
	$letexte = ereg_replace("(<[^>]+>)", "", $letexte);
	$letexte = ereg_replace("&nbsp;", " ", $letexte);
	return $letexte;
}

function couper($texte, $long) {
	$texte2 = substr($texte, 0, $long * 2); /* heuristique pour prendre seulement le necessaire */
	if (strlen($texte2) < strlen($texte)) $plus_petit = true;
	$texte = ereg_replace("\[([^\[]*)->([^]]*)\]","\\1", $texte2);

	while(strpos($texte,"[[") > 0) {
		$debut=substr($texte,0,strpos($texte,"[["));
		$zet=substr($texte,strpos($texte,"[[")+2,strlen($texte));
		$milieu=substr($zet,0,strpos($zet,"]]"));
		$fin=substr($zet,strpos($zet,"]]")+2,strlen($zet));
		$texte=$debut.$fin;
	}

	$texte = ereg_replace("\{"," ",$texte);
	$texte = ereg_replace("\}"," ",$texte);

	$texte2 = substr($texte." ", 0, $long);
	$texte2 = ereg_replace("([^[:space:]][[:space:]]+)[^[:space:]]*$", "\\1", $texte2);
	if ((strlen($texte2) + 3) < strlen($texte)) $plus_petit = true;
	if ($plus_petit) $texte2 .= ' (...)';
	return $texte2;
}


// si besoin cree le code qui remplacera la puce, l'intertitre, etc.
if (!$puce) {
	if (file_exists("puce.gif")) {
		$puce_taille = getimagesize("puce.gif");
		$puce = "<IMG SRC='puce.gif' ALIGN='top' ".$puce_taille[3].
			" BORDER='0'> ";
	} else {
		$puce="- ";
	}
}

if (!$debut_intertitre) {
	$debut_intertitre = "<BR><BR><P><CENTER><B><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE='+1'>";
	$fin_intertitre = "</FONT></B></CENTER><BR>";
}


function ereg_remplace($cherche_tableau, $remplace_tableau, $texte) {
	global $flag_preg_replace;

	if ($flag_preg_replace) return preg_replace($cherche_tableau, $remplace_tableau, $texte);

	$n = count($cherche_tableau);

	for ($i = 0; $i < $n; $i++) {
		$texte = ereg_replace(substr($cherche_tableau[$i], 1, -1), $remplace_tableau[$i], $texte);
	}
	return $texte;
}


// correction typographique francaise
function typo($letexte, $lang = 'fr') {

	global $flag_preg_replace;

	$blanc_dur = "(&nbsp;|".chr(160)."|".chr(202).")";
	$letexte = ereg_replace($blanc_dur, "~", $letexte);

	$cherche1 = array(
		/* 2 */ 	'/([^\#0-9a-zA-Z\&][\#0-9a-zA-Z]*)\;/',
		/* 3 */		'/(\:|\!|\?||&raquo;|&#187;)/',
//		/* 4 */		'/(|&laquo;|&#171;|(M(M?\.|mes?|r\.?)|[0-9]|[MnN]) )/',
		/* 4 */		'/(|&laquo;|&#171;|(M(M?\.|mes?|r\.?)|[MnN]) )/',
		/* 6 */		'/ +-,/'
	);
	$remplace1 = array(
		/* 2 */		'\1~;',
		/* 3 */		'~\1',
		/* 4 */		'\1~',
		/* 6 */		'~-,'
	);

	$letexte = ereg_remplace($cherche1, $remplace1, $letexte);
	$letexte = ereg_replace(" *~+ *", "~", $letexte);

	$cherche2 = array(
		'/(http|ftp|mailto)~:/',
		'/~/'
	);
	$remplace2 = array(
		'\1:',
		'&nbsp;'
	);

	$letexte = ereg_remplace($cherche2, $remplace2, $letexte);

	// retablir les vrais ~ dans les liens (minimal)
	$letexte = eregi_replace("<A ([^>]*)&nbsp;([^>]*)>","<A \\1~\\2>",$letexte);

	return ($letexte);
}


// nettoie un texte, traite les raccourcis spip, la typo, etc.
function propre($letexte) {
	global $puce;
	global $debut_intertitre, $fin_intertitre;
	global $id_article;
	global $compt_note;
	global $compt_sources;
	global $les_notes;
	global $compt_liens;
	global $flag_strpos_3, $flag_preg_replace, $flag_str_replace;

	$letexte = stripslashes($letexte);

	// Echappement pour texte brute
	while (($cur = strpos($letexte,"<HTML>")) > 0) {
		$compt_sources++;
		$debut = substr($letexte, 0, $cur);
		$zet = substr($letexte, $cur + 6);
		$cur = strpos($zet, "</HTML>");
		$milieu = substr($zet, 0, $cur);
		$fin=substr($zet, $cur + 7);
		$letexte=$debut."<SOURCE$compt_sources>".$fin;
		$zesources[$compt_sources]=$milieu;
	}

	// Harmoniser les retours chariot
	if ($flag_str_replace)
		$letexte = str_replace("\r", "\n", $letexte);
	else
		$letexte = ereg_replace("\r", "\n", $letexte);

	// Notes de bas de page
	if ($flag_strpos_3) {
		$pos = 0;
		$cur = 0;
		$letexte2 = "";
		while (($cur = strpos($letexte, "[[", $pos)) > 0) {
			$letexte2 .= substr($letexte, $pos, $cur - $pos);
			$q = strpos($letexte, "]]", $cur);

			if ($q) {
				while (substr($letexte, $q + 1, 2) == ']]') $q++;
				$note_texte = substr($letexte, $cur + 2, $q - $cur - 2);
				$num_note=false;
				if (ereg("^ *<([^>]*)>",$note_texte,$regs)){ // note pas auto ?
					$num_note=$regs[1];
					$note_texte = ereg_replace ("^ *<([^>]*)>","",$note_texte);
				} else { // note auto
					$compt_note++;
					$num_note=$compt_note;
				}
				if ($num_note){
					$letexte2 .= "&nbsp;[<A HREF='#nb$num_note' NAME='nh$num_note'>$num_note</A>]";
					if ($note_texte)
						$les_notes .= "<P align='left'>[<A HREF='#nh$num_note' NAME='nb$num_note'>$num_note</A>] ".propre($note_texte);
				} else {
					if ($note_texte)
						$les_notes .= "<P align='left'>".propre($note_texte);
				}
				$pos = $q + 2;
			}
			else break;
		}
		$letexte = $letexte2.substr($letexte, $pos);
	}
	else {
		while (($cur = strpos($letexte, "[[")) > 0){
			$debut = substr($letexte, 0, $cur);
			$zet = substr($letexte, $cur + 2);
			$cur = strpos($zet, "]]");
			while (substr($zet, $cur + 1, 2) == ']]') $cur++;
			$note_texte = substr($zet, 0, $cur);
			$fin = substr($zet, $cur + 2);
			$num_note=false;
			if (ereg("^ *<([^>]*)>",$note_texte,$regs)){ // note pas auto ?
				$num_note=$regs[1];
				$note_texte = ereg_replace ("^ *<([^>]*)>","",$note_texte);
			} else { // note auto
				$compt_note++;
				$num_note=$compt_note;
			}
			if ($num_note){
				$letexte = $debut."&nbsp;[<A HREF='#nb$num_note' NAME='nh$num_note'>$num_note</A>]".$fin;
				if ($note_texte)
					$les_notes .= "<P align='left'>[<A HREF='#nh$num_note' NAME='nb$num_note'>$num_note</A>] ".propre($note_texte);
			} else {
				$letexte = $debut.$fin;
				if ($note_texte)
					$les_notes .= "<P align='left'>".propre($note_texte);
			}
		}
	}

	// Raccourcis liens
	$letexte2 = "";
	$fin = $letexte;
	while (($cur = strpos($fin, '[')) > 0 OR substr($fin, 0, 1) == '[') {
		$letexte2 .= typo(substr($fin, 0, $cur));
		$fin = substr($fin, $cur);
		$q = strpos($fin, ']');

		if ($q) {
			$milieu = substr($fin, 1, $q - 1);
			$p = strpos($milieu, '->');
			if ($p) {
				// Le lien a ete trouve
				$lien_texte = typo(substr($milieu, 0, $p));
				$lien_url = trim(substr($milieu, $p + 2));
				$compt_liens++;
				if (ereg('^(art(icle)?|rub(rique)?|br(e|)ve)? *([[:digit:]]+)$', $lien_url, $match)) {
					// Traitement des liens internes
					$id_lien = $match[5];
					$type_lien = $match[1];
					switch ($type_lien) {
						case 'rub':
						case 'rubrique':
							$lien_url = generer_url_rubrique($id_lien);
							break;
						case 'breve':
						case 'brve':
							$lien_url = generer_url_breve($id_lien);
							break;
						default:
							$lien_url = generer_url_article($id_lien);
							break;
					}
				}
				$letexte2 .= "<A HREF=\"$lien_url\">$lien_texte</A>";
				$zeliens[$compt_liens]=$lien_url;
				$fin = substr($fin, $q + 1);
			}
			else {
				$letexte2 .= typo(substr($fin, 0, $q + 1));
				$fin = substr($fin, $q + 1);
			}
		}
		else break;
	}
	$letexte = $letexte2.typo($fin);

	// Tableaux SPIP -> HTML
	if (strpos($letexte, "\n\n\|")) {
		$letexte = ereg_replace("\n\n\n\|","<P align='center'><TABLE CELLPADDING=4><TR><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
		$letexte = ereg_replace("\|\n\n\n","|</TD></TR></TABLE><P>",$letexte);
		$letexte = ereg_replace("\n\|","<TR><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
		$letexte = ereg_replace("\|\n","</TD></TR>\n",$letexte);
		$letexte = ereg_replace("\|","</TD><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
	}

	// Insertion d'images utilisateur
	while(ereg("<IMG([0-9]+)\|([^\>]*)>",$letexte,$match)) {
		$letout = quotemeta($match[0]);
		$letout = ereg_replace("\|","\|",$letout);
		$lenum = $match[1];
		$lalign = $match[2];
		$rempl = integre_image($id_article, $lenum, $lalign);
		$letexte = ereg_replace($letout, $rempl, $letexte);
	}


	// Mise en forme
	$letexte = ereg_replace("(( *)\n){3,}","<P>\n", trim($letexte));

	if ($flag_str_replace && !$flag_preg_replace) {
		$letexte = ereg_replace("^-", "$puce ", $letexte);
		$letexte = str_replace("\n-", "<BR>$puce ",$letexte);
		$letexte = str_replace("", "'", $letexte);
		$letexte = str_replace("{{{", $debut_intertitre, $letexte);
		$letexte = str_replace("}}}", $fin_intertitre, $letexte);
		$letexte = str_replace("{{", "<B>", $letexte);
		$letexte = str_replace("}}", "</B>", $letexte);
		$letexte = str_replace("{", "<I>", $letexte);
		$letexte = str_replace("}", "</I>", $letexte);
		$letexte = ereg_replace("(<BR>)+(<P>|<BR>)", "<P>", $letexte);
	}
	else {
		$cherche1 = array(
			/* 2 */		"/^-/",
			/* 3 */		"/\n-/",
			/* 4 */		"//",
			/* 5 */		"/\{\{\{/",
			/* 6 */		"/\}\}\}/",
			/* 7 */		"/\{\{/",
			/* 8 */		"/\}\}/",
			/* 9 */		"/\{/",
			/* 10 */	"/\}/",
			/* 11 */	"/(<BR>){2,}/",
			/* 12 */	"/<P>([\n]*)(<BR>)+/"
		);
		$remplace1 = array(
			/* 2 */ 	"$puce ",
			/* 3 */ 	"<BR>$puce ",
			/* 4 */ 	"'",
			/* 5 */ 	"$debut_intertitre",
			/* 6 */ 	"$fin_intertitre",
			/* 7 */ 	"<B>",
			/* 8 */ 	"</B>",
			/* 9 */ 	"<I>",
			/* 10 */ 	"</I>",
			/* 11 */ 	"<P>",
			/* 12 */ 	"<P>"
		);
		$letexte = ereg_remplace($cherche1, $remplace1, $letexte);
	}

	// Traitement final des echappements texte brut
	while(ereg("<SOURCE([0-9]+)>",$letexte,$match)){
		$lenum=$match[1];
		$rempl=$zesources[$lenum];
		$letexte=ereg_replace("<SOURCE$lenum>","$rempl",$letexte);
	}

	// Securite : empecher l'execution de code PHP
	$letexte = eregi_replace("<(\%|\?|( *)script)", "&lt;\\1", $letexte);

	return $letexte;
}


?>
