<?

//
// Gestion des differentes versions de php
//

$flag_strpos_3 = (@strpos('baba', 'a', 2) == 3);
$php_version = explode('.', phpversion());
$php_version_maj = (int) $php_version[0];
$php_version_med = (int) $php_version[1];
if (ereg('[0-9]+', $php_version[2], $match)) $php_version_min = (int) $match[1];

$flag_str_replace = ($php_version_maj >= 3 OR $php_version_min >= 8);

//
// Trouver une locale qui 'marche' : si 'fr' et 'fr_FR' ne suffisent pas,
// il suffit d'ajouter des lignes...
//

setlocale('LC_CTYPE', 'fr') ||
setlocale('LC_CTYPE', 'FR_fr') ||
setlocale('LC_CTYPE', 'fr_FR');


function vider_date($letexte) {
	if (ereg("^0000-00-00", $letexte)) return '';
	return $letexte;
}

function affdate_base($numdate, $vue, $lang = 'fr') {
	if (!$numdate) return '';
	if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
		$mois = $regs[2];
		$annee = $regs[3];
		/* si Excel (tm) se mele des dates, il faut les demeler */
		if ($annee < 90){
			$annee = 2000 + $annee;
		} else {
			$annee = 1900 + $annee ;
		}
	}
	else if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})',$numdate, $regs)) {
		$annee = $regs[1];
		$mois = $regs[2];
		$jour = $regs[3];
	}
	else if (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
		$annee = $regs[1];
		$mois = $regs[2];
	}
	if ($annee > 4000) $annee -= 9000;
	if (substr($jour, 0, 1) == '0') $jour = substr($jour, 1);
	if (($lang ==  "") || ($lang == "fr")) {
		if ($jour == '1') $jour = '1er';
		$tab_mois = array(0,
			'janvier', 'f&eacute;vrier', 'mars', 'avril', 'mai', 'juin',
			'juillet', 'ao&ucirc;t', 'septembre', 'octobre', 'novembre', 'd&eacute;cembre');
		$avjc = ' av. J.C.';
	}
	else {
		switch($jour) {
		case '1':
			$jour = '1st';
			break;
		case '2':
			$jour = '2nd';
			break;
		case '3':
			$jour = '3rd';
			break;
		case '21':
			$jour = '21st';
			break;
		case '22':
			$jour = '22nd';
			break;
		case '23':
			$jour = '23rd';
			break;
		case '31':
			$jour = '31st';
			break;
		}
		$tab_mois = array(0,
			'january', 'february', 'march', 'april', 'may', 'june',
			'july', 'august', 'september', 'october', 'november', 'december');
		$avjc = ' B.C.';
	}

	if ($jour) $jour .= ' ';
	$mois = $tab_mois[(int) $mois];
	if ($annee < 0) {
		$annee = -$annee.$avjc;
		$avjc = true;
	}
	else $avjc = false;

	switch ($vue) {
	case 'court':
		if ($avjc) return $annee;
		$a = date('Y');
		if ($annee < ($a - 100) OR $annee > ($a + 100)) return $annee;
		if ($annee != $a) return ucfirst($mois)." $annee";
		return $jour.$mois;

	case 'entier':
		if ($avjc) return $annee;
		return "$jour$mois $annee";

	case 'mois_annee':
		if ($avjc) return $annee;
		return "$mois $annee";
	}

	return '<blink>format non d&eacute;fini</blink>';
}


function affdate($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'entier', $lang);
}


function affdate_court($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'court', $lang);
}


function affdate_mois_annee($numdate, $lang = 'fr') {
	return affdate_base($numdate, 'mois_annee', $lang);
}


function majuscules($texte) {
	$suite = htmlentities($texte);
	$suite = ereg_replace('&amp;', '&', $suite);
	$suite = ereg_replace('&lt;', '<', $suite);
	$suite = ereg_replace('&gt;', '>', $suite);
//	$suite = $texte;
	$texte = '';
	while (ereg('^([^&]*)&([A-Za-z])([a-zA-Z]*);(.*)$', $suite, $regs)) {
		$texte .= strtoupper($regs[1]);
		$suite = $regs[4];
		$carspe = $regs[2];
		$accent = $regs[3];
		if (ereg('^(acute|grave|circ|uml|cedil|slash|caron|ring|tilde|elig)$', $accent))
			$carspe = strtoupper($carspe); 
		if ($accent == 'elig') $accent = 'Elig';
		$texte .= '&'.$carspe.$accent.';';
	}
	$texte .= strtoupper($suite);
	return $texte;
}

function justifier($letexte) {
	$letexte = eregi_replace("<P>","\n<P align='justify'>",$letexte);
	return "<P align='justify'>".$letexte;
}

function textebrut($letexte) {
	$letexte = ereg_replace("(<[^>]+>)", "", $letexte);
	$letexte = ereg_replace("&nbsp;", " ", $letexte);
	return $letexte;
}

function couper($texte, $long) {
	$texte2 = substr($texte, 0, $long * 2); /* heuristique pour prendre seulement le necessaire */
	if (strlen($texte2) < strlen($texte)) $plus_petit = true;
	$texte = ereg_replace("\[([^\[]*)->([^]]*)\]","\\1", $texte2);

	while(strpos($texte,"[[")>0) {
		$debut=substr($texte,0,strpos($texte,"[["));
		$zet=substr($texte,strpos($texte,"[[")+2,strlen($texte));
		$milieu=substr($zet,0,strpos($zet,"]]"));
		$fin=substr($zet,strpos($zet,"]]")+2,strlen($zet));
		$texte=$debut.$fin;
	}

	$texte = ereg_replace("\{"," ",$texte);
	$texte = ereg_replace("\}"," ",$texte);

	$texte2 = substr($texte." ", 0, $long);
	$texte2 = ereg_replace("([^[:space:]][[:space:]]+)[^[:space:]]*$", "\\1", $texte2);
	if ((strlen($texte2) + 3) < strlen($texte)) $plus_petit = true;
	if ($plus_petit) $texte2 .= ' (...)';
	return $texte2;
}


// si besoin cree le code qui remplacera la puce, l'intertitre, etc.
if (!$puce) {
	if (file_exists("puce.gif")) {
		$puce_taille = getimagesize("puce.gif");
		$puce = "<IMG SRC='puce.gif' ALIGN='top' ".$puce_taille[3].
			" BORDER='0'> ";
	} else {
		$puce="- ";
	}
}

if (!$debut_intertitre) {
	$debut_intertitre = "<BR><BR><P><CENTER><B><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE='+1'>";
	$fin_intertitre = "</FONT></B></CENTER><BR>";
}



// correction typographique francaise
function typo($letexte, $lang = 'fr') {

	// virgule et ital : pas de faux blanc dans Netscape
	$letexte=eregi_replace("</I>,",",</I>",$letexte);

	// insecables
	$blanc_dur = "(&nbsp;|".chr(160)."|".chr(202)."|~)";
	$letexte=ereg_replace($blanc_dur,"~",$letexte);

	// le ; -> eviter les entites html
	$letexte=ereg_replace("([^\#[:alnum:]\&][\#[:alnum:]]*)\;", "\\1~;",$letexte);
	$letexte=ereg_replace("(\:|\!|\?||\&raquo\;|&#187;)", "~\\1",$letexte);
	$letexte=ereg_replace("(|&laquo;|&#171;)","\\1~",$letexte);
	$letexte=ereg_replace("([0-9])[ ~]","\\1~",$letexte);
	$letexte=ereg_replace("(M?M\.|Mmes?|Mgr|Mlles?|(Mr|Mrs|Ms)\.?)[ ~]","\\1~",$letexte);
	$letexte=ereg_replace("([MnN])","\\1~",$letexte);
	$letexte=ereg_replace(" *~+ *","~",$letexte);

	// exceptions
	$letexte=ereg_replace("(http|ftp|mailto)~:", "\\1:",$letexte);

	// final = &nbsp;
	$letexte=ereg_replace("~","&nbsp;",$letexte);

	// retablir les vrais ~
	$letexte=ereg_replace("<A ([^<]*)&nbsp;([^<]*)>","<A \\1~\\2>",$letexte);

	return ($letexte);
}


// nettoie un texte, traite les raccourcis spip, la typo, etc.
function propre($letexte) {
	global $puce;
	global $debut_intertitre, $fin_intertitre;
	global $id_article;
	global $compt_note;
	global $compt_sources;
	global $les_notes;
	global $compt_liens;
	global $flag_strpos_3;

	$letexte = stripslashes($letexte);

	while (($cur = strpos($letexte,"<HTML>")) > 0) {
		$compt_sources++;
		$debut = substr($letexte, 0, $cur);
		$zet = substr($letexte, $cur + 6);
		$cur = strpos($zet, "</HTML>");
		$milieu = substr($zet, 0, $cur);
		$fin=substr($zet, $cur + 7);
		$letexte=$debut."<SOURCE$compt_sources>".$fin;
		$zesources[$compt_sources]=$milieu;
	}

	$letexte = ereg_replace("\r", "\n",$letexte);

	if ($flag_strpos_3) {

		$pos = 0;
		$cur = 0;
		$letexte2 = "";
		while (($cur = strpos($letexte, "[[", $pos)) > 0) {
			$letexte2 .= substr($letexte, $pos, $cur - $pos);
			$q = strpos($letexte, "]]", $cur);

			if ($q) {
				while (substr($letexte, $q + 1, 2) == ']]') $q++;
				$note_texte = substr($letexte, $cur + 2, $q - $cur - 2);
				$compt_note++;
				$letexte2 .= "&nbsp;[<A HREF='#nb$compt_note' NAME='nh$compt_note'>$compt_note</A>]";
				$pos = $q + 2;
				$les_notes .= "<P align='left'>[<A HREF='#nh$compt_note' NAME='nb$compt_note'>$compt_note</A>] ".propre($note_texte);
			}
			else break;
		}
		$letexte = $letexte2.substr($letexte, $pos);

		$pos = 0;
		$cur = 0;
		$letexte2 = "";
		while (($cur = strpos($letexte, "[", $pos)) > 0 OR substr($letexte, $pos, 1) == '[') {
			$letexte2 .= substr($letexte, $pos, $cur - $pos);
			$q = strpos($letexte, "]", $cur);

			if ($q) {
				$milieu = substr($letexte, $cur + 1, $q - $cur - 1);
				$p = strpos($milieu, "->");
				if ($p) {
					$lien_texte = substr($milieu, 0, $p);
					$lien_url = substr($milieu, $p + 2);
					$compt_liens++;
					$letexte2 .= "<A HREF=\"<LIEN$compt_liens>\">$lien_texte</A>";
					$zeliens[$compt_liens] = $lien_url;
				}
				else {
					$letexte2 .= "[$milieu]";
				}
				$pos = $q + 1;
			}
			else break;
		}
		$letexte = $letexte2.substr($letexte, $pos);

	}
	else {

		while (($cur = strpos($letexte,"[[")) > 0){
			$compt_note++;
			$debut = substr($letexte, 0, $cur);
			$zet = substr($letexte, $cur + 2);
			$cur = strpos($zet, "]]");
			while (substr($zet, $cur + 1, 2) == ']]') $cur++;
			$milieu = substr($zet, 0, $cur);
			$fin = substr($zet, $cur + 2);
			$letexte = $debut."&nbsp;[<A HREF='#nb$compt_note' NAME='nh$compt_note'>$compt_note</A>]".$fin;
			$les_notes .= "<P align='left'>[<A HREF='#nh$compt_note' NAME='nb$compt_note'>$compt_note</A>] ".propre($milieu);
		}

		$letexte2 = "";
		$fin = $letexte;
		while (($cur = strpos($fin, "[")) > 0 OR substr($fin, 0, 1) == '[') {
			$letexte2 .= substr($fin, 0, $cur);
			$fin = substr($fin, $cur);
			$q = strpos($fin, "]");
	
			if ($q) {
				$milieu = substr($fin, 1, $q - 1);
				$p = strpos($milieu, "->");
				if ($p) {
					$lien_texte = substr($milieu, 0, $p);
					$lien_url = substr($milieu, $p + 2);
					$compt_liens++;
					$letexte2 .= "<A HREF=\"<LIEN$compt_liens>\">$lien_texte</A>";
					$zeliens[$compt_liens]=$lien_url;
					$fin = substr($fin, $q + 1);
				}
				else {
					$letexte2 .= substr($fin, 0, $q + 1);
					$fin = substr($fin, $q + 1);
				}
			}
			else break;
		}
		$letexte = $letexte2.$fin;

	}

	if (ereg("\n\n\|",$letexte)){
		$letexte=ereg_replace("\n\n\n\|","<P align='center'><TABLE CELLPADDING=4><TR><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
		$letexte=ereg_replace("\|\n\n\n","|</TD></TR></TABLE><P>",$letexte);
		$letexte=ereg_replace("\n\|","<TR><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
		$letexte=ereg_replace("\|\n","</TD></TR>\n",$letexte);
		$letexte=ereg_replace("\|","</TD><TD ALIGN='center' BGCOLOR='#DDDDDD'>",$letexte);
	}

	while(ereg("<IMG([0-9]+)\|([^\>]*)>",$letexte,$match)) {
		$letout=quotemeta($match[0]);
		$letout=ereg_replace("\|","\|",$letout);
		$lenum=$match[1];
		$lalign=$match[2];
		$rempl=integre_image($id_article, $lenum, $lalign);
		$letexte=ereg_replace($letout, $rempl, $letexte);
	}

	$letexte=ereg_replace("(( *)\n){3,}","<P>\n",$letexte);
	$letexte=trim($letexte);

	// Mise en forme
	$letexte=ereg_replace("[\r\n ]+$", "", $letexte);
	$letexte=ereg_replace("^-", "$puce ", $letexte);
	$letexte=ereg_replace("\n-", "<BR>$puce ", $letexte);
	$letexte=ereg_replace("", "'", $letexte);
	$letexte=ereg_replace("{{{", $debut_intertitre, $letexte);
	$letexte=ereg_replace("}}}", $fin_intertitre, $letexte);
	$letexte=ereg_replace("{{", "<B>", $letexte);
	$letexte=ereg_replace("}}", "</B>", $letexte);
	$letexte=ereg_replace("{", "<I>", $letexte);
	$letexte=ereg_replace("}", "</I>", $letexte);
	$letexte=ereg_replace("(<BR>){2,}", "<P>", $letexte);
	$letexte=ereg_replace("<P>([\n]*)(<BR>){1,}", "<P>", $letexte);

	// typographie
	$letexte=typo($letexte);

	while(ereg("<LIEN([0-9]+)>",$letexte,$match)){
		$lenum=$match[1];
		$rempl=$zeliens[$lenum];
		$letexte=ereg_replace("<LIEN$lenum>","$rempl",$letexte);
	}
	while(ereg("<SOURCE([0-9]+)>",$letexte,$match)){
		$lenum=$match[1];
		$rempl=$zesources[$lenum];
		$letexte=ereg_replace("<SOURCE$lenum>","$rempl",$letexte);
	}

	// Securite
	$letexte = eregi_replace("<( *)script", "&lt;script", $letexte);
	$letexte = ereg_replace("<%", "&lt;%", $letexte);
	$letexte = ereg_replace("<\?", "&lt;?", $letexte);

	return $letexte;
}


?>
